/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.sra.RouteProvider;
import org.apache.syncope.sra.SRAProperties;
import org.apache.syncope.sra.security.web.server.DoNothingIfCommittedServerRedirectStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;

public abstract class AbstractServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler,
ApplicationListener<RefreshRoutesEvent> {
    private static final Map<String, Optional<URI>> CACHE = new ConcurrentHashMap<String, Optional<URI>>();
    protected final ServerRedirectStrategy redirectStrategy = new DoNothingIfCommittedServerRedirectStrategy();
    @Autowired
    private RouteProvider routeProvider;
    @Autowired
    private SRAProperties props;

    public void onApplicationEvent(RefreshRoutesEvent event) {
        CACHE.clear();
    }

    protected URI getPostLogout(WebFilterExchange exchange) {
        Optional routePostLogout;
        URI postLogout = this.props.getGlobal().getPostLogout();
        String routeId = (String)exchange.getExchange().getAttribute(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
        if (StringUtils.isNotBlank((CharSequence)routeId) && (routePostLogout = Optional.ofNullable(CACHE.get(routeId)).orElseGet(() -> {
            Optional<SRARouteTO> route = this.routeProvider.getRouteTOs().stream().filter(r -> routeId.equals(r.getKey())).findFirst();
            URI uri = route.map(SRARouteTO::getPostLogout).orElse(null);
            CACHE.put(routeId, Optional.ofNullable(uri));
            return CACHE.get(routeId);
        })).isPresent()) {
            postLogout = (URI)routePostLogout.get();
        }
        return postLogout;
    }
}

