/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;

public abstract class FieldPanel<T>
extends AbstractFieldPanel<T>
implements Cloneable {
    private static final long serialVersionUID = -198988924922541273L;
    protected FormComponent<T> field = null;
    protected String title = null;
    protected boolean isRequiredLabelAdded = false;

    public FieldPanel(String id, IModel<T> model) {
        super(id, model);
        Fragment fragment = new Fragment("required", "notRequiredFragment", (MarkupContainer)this);
        this.add(new Component[]{fragment});
        this.setOutputMarkupId(true);
    }

    public FormComponent<T> getField() {
        return this.field;
    }

    public FieldPanel<T> setTitle(String title) {
        this.title = title;
        this.field.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)(title != null ? title : "")))});
        return this;
    }

    public FieldPanel<T> setStyleSheet(String classes) {
        this.field.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes != null ? classes : "")))});
        return this;
    }

    public FieldPanel<T> setRequired(boolean required) {
        this.field.setRequired(required);
        return this;
    }

    public FieldPanel<T> setReadOnly(boolean readOnly) {
        this.field.setEnabled(!readOnly);
        return this;
    }

    public boolean isRequired() {
        return this.field.isRequired();
    }

    public boolean isReadOnly() {
        return !this.field.isEnabled();
    }

    public FieldPanel<T> addRequiredLabel() {
        if (!this.isRequired()) {
            this.setRequired(true);
        }
        Fragment fragment = new Fragment("required", "requiredFragment", (MarkupContainer)this);
        fragment.add(new Component[]{new Label("requiredLabel", "*")});
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = true;
        return this;
    }

    public FieldPanel<T> removeRequiredLabel() {
        if (this.isRequired()) {
            this.setRequired(false);
        }
        Fragment fragment = new Fragment("required", "notRequiredFragment", (MarkupContainer)this);
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = false;
        return this;
    }

    public FieldPanel<T> setModelObject(T object) {
        this.field.setModelObject(object);
        return this;
    }

    public T getModelObject() {
        return (T)this.field.getModelObject();
    }

    public FieldPanel<T> setNewModel(IModel<T> model) {
        this.field.setModel(model);
        return this;
    }

    public FieldPanel<T> setNewModel(ListItem<T> item) {
        this.setNewModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public FieldPanel<T> setNewModel(List<Serializable> list) {
        this.setNewModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public FieldPanel<T> clone() {
        FieldPanel panel = (FieldPanel)SerializationUtils.clone((Serializable)this);
        panel.setModelObject(null);
        return panel;
    }
}

