/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.console.preview.PreviewUtil;
import org.apache.syncope.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.crypt.Base64;
import org.apache.wicket.util.lang.Bytes;

public class BinaryFieldPanel
extends FieldPanel<String> {
    private static final long serialVersionUID = 6264462604183088931L;
    private final String mimeType;
    private final WebMarkupContainer container;
    private final Link<Void> downloadLink;
    private final Form<?> uploadForm;
    private final Fragment emptyFragment;
    @SpringBean
    private PreviewUtil previewUtil;

    public BinaryFieldPanel(String id, String name, IModel<String> model, String mimeType) {
        super(id, model);
        this.mimeType = mimeType;
        this.uploadForm = new StatelessForm("uploadForm");
        this.uploadForm.setMultiPart(true);
        this.uploadForm.setMaxSize(Bytes.megabytes((long)4L));
        this.add(new Component[]{this.uploadForm});
        this.container = new WebMarkupContainer("previewContainer");
        this.container.setOutputMarkupId(true);
        this.emptyFragment = new Fragment("panelPreview", "emptyFragment", (MarkupContainer)this.container);
        this.emptyFragment.setOutputMarkupId(true);
        this.container.add(new Component[]{this.emptyFragment});
        this.uploadForm.add(new Component[]{this.container});
        this.field = new TextField("textField", model);
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
        this.uploadForm.add(new Component[]{new Label("preview", StringUtils.isBlank((CharSequence)mimeType) ? "" : "(" + mimeType + ")")});
        this.downloadLink = new /* Unavailable Anonymous Inner Class!! */;
        this.downloadLink.setOutputMarkupId(true);
        this.uploadForm.add(new Component[]{this.downloadLink});
        FileUploadField fileUpload = new FileUploadField("fileUpload", (IModel)new Model());
        fileUpload.setOutputMarkupId(true);
        fileUpload.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.uploadForm.add(new Component[]{fileUpload});
        3 uploadLink = new /* Unavailable Anonymous Inner Class!! */;
        this.uploadForm.add(new Component[]{uploadLink});
        4 resetLink = new /* Unavailable Anonymous Inner Class!! */;
        this.uploadForm.add(new Component[]{resetLink});
    }

    private Response buildResponse() {
        return Response.ok((Object)new ByteArrayInputStream(Base64.decodeBase64((String)((String)this.getModelObject())))).type(StringUtils.isBlank((CharSequence)this.mimeType) ? "application/octet-stream" : this.mimeType).build();
    }

    private void changePreviewer(Component panelPreview) {
        Fragment fragment = new Fragment("panelPreview", "previewFragment", (MarkupContainer)this.container);
        fragment.add(new Component[]{panelPreview});
        this.container.addOrReplace(new Component[]{fragment});
        this.uploadForm.addOrReplace(new Component[]{this.container});
    }

    public BinaryFieldPanel clone() {
        return (BinaryFieldPanel)super.clone();
    }

    public FieldPanel<String> setNewModel(IModel<String> model) {
        this.field.setModel(model);
        try {
            Component panelPreview = this.previewUtil.getPreviewer(this.mimeType, (String)model.getObject());
            if (panelPreview != null) {
                this.changePreviewer(panelPreview);
            }
        }
        catch (Exception e) {
            LOG.error("While loading saved file", (Throwable)e);
        }
        this.downloadLink.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)model.getObject())));
        this.uploadForm.addOrReplace(new Component[]{this.downloadLink});
        return this;
    }

    static /* synthetic */ Response access$000(BinaryFieldPanel x0) {
        return x0.buildResponse();
    }

    static /* synthetic */ PreviewUtil access$100(BinaryFieldPanel x0) {
        return x0.previewUtil;
    }

    static /* synthetic */ void access$200(BinaryFieldPanel x0, Component x1) {
        x0.changePreviewer(x1);
    }

    static /* synthetic */ Form access$300(BinaryFieldPanel x0) {
        return x0.uploadForm;
    }

    static /* synthetic */ Link access$400(BinaryFieldPanel x0) {
        return x0.downloadLink;
    }

    static /* synthetic */ Fragment access$500(BinaryFieldPanel x0) {
        return x0.emptyFragment;
    }

    static /* synthetic */ WebMarkupContainer access$600(BinaryFieldPanel x0) {
        return x0.container;
    }
}

