/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.mod.ResourceAssociationMod;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.ResourceService;
import org.apache.syncope.common.services.UserService;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.types.SubjectType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.common.wrap.ResourceName;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Component;

@Component
public class UserRestClient
extends AbstractSubjectRestClient {
    private static final long serialVersionUID = -1575748964398293968L;

    public int count() {
        return ((UserService)this.getService(UserService.class)).list(Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public List<UserTO> list(int page, int size, SortParam<String> sort) {
        return ((UserService)this.getService(UserService.class)).list(Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort), false).getResult();
    }

    public UserTO create(UserTO userTO, boolean storePassword) {
        Response response = ((UserService)this.getService(UserService.class)).create(userTO, storePassword);
        return (UserTO)response.readEntity(UserTO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTO update(String etag, UserMod userMod) {
        UserTO result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            result = (UserTO)service.update(Long.valueOf(userMod.getId()), userMod).readEntity(UserTO.class);
            this.resetClient(UserService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTO delete(String etag, Long id) {
        UserTO result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            result = (UserTO)service.delete(id).readEntity(UserTO.class);
            this.resetClient(UserService.class);
        }
        return result;
    }

    public UserTO read(Long id) {
        UserTO userTO = null;
        try {
            userTO = ((UserService)this.getService(UserService.class)).read(id);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a user", (Throwable)e);
        }
        return userTO;
    }

    public int searchCount(String fiql) {
        return ((UserService)this.getService(UserService.class)).search(fiql, Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public List<UserTO> search(String fiql, int page, int size, SortParam<String> sort) {
        return ((UserService)this.getService(UserService.class)).search(fiql, Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort), false).getResult();
    }

    public ConnObjectTO getConnectorObject(String resourceName, Long id) {
        return ((ResourceService)this.getService(ResourceService.class)).getConnectorObject(resourceName, SubjectType.USER, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(String etag, long userId, List<StatusBean> statuses) {
        StatusMod statusMod = StatusUtils.buildStatusMod(statuses, (Boolean)false);
        statusMod.setType(StatusMod.ModType.SUSPEND);
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            service.status(Long.valueOf(userId), statusMod);
            this.resetClient(UserService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reactivate(String etag, long userId, List<StatusBean> statuses) {
        StatusMod statusMod = StatusUtils.buildStatusMod(statuses, (Boolean)true);
        statusMod.setType(StatusMod.ModType.REACTIVATE);
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            service.status(Long.valueOf(userId), statusMod);
            this.resetClient(UserService.class);
        }
    }

    public BulkActionResult bulkAction(BulkAction action) {
        return ((UserService)this.getService(UserService.class)).bulk(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(String etag, long userId, List<StatusBean> statuses) {
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            service.bulkDeassociation(Long.valueOf(userId), ResourceDeassociationActionType.UNLINK, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            this.resetClient(UserService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(String etag, long userId, List<StatusBean> statuses) {
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            ResourceAssociationMod associationMod = new ResourceAssociationMod();
            associationMod.getTargetResources().addAll(CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            service.bulkAssociation(Long.valueOf(userId), ResourceAssociationActionType.LINK, associationMod);
            this.resetClient(UserService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult deprovision(String etag, long userId, List<StatusBean> statuses) {
        BulkActionResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            result = (BulkActionResult)service.bulkDeassociation(Long.valueOf(userId), ResourceDeassociationActionType.DEPROVISION, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(UserService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult provision(String etag, long userId, List<StatusBean> statuses, boolean changepwd, String password) {
        BulkActionResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            ResourceAssociationMod associationMod = new ResourceAssociationMod();
            associationMod.getTargetResources().addAll(CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            associationMod.setChangePwd(changepwd);
            associationMod.setPassword(password);
            result = (BulkActionResult)service.bulkAssociation(Long.valueOf(userId), ResourceAssociationActionType.PROVISION, associationMod).readEntity(BulkActionResult.class);
            this.resetClient(UserService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult unassign(String etag, long userId, List<StatusBean> statuses) {
        BulkActionResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            result = (BulkActionResult)service.bulkDeassociation(Long.valueOf(userId), ResourceDeassociationActionType.UNASSIGN, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(UserService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult assign(String etag, long userId, List<StatusBean> statuses, boolean changepwd, String password) {
        BulkActionResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            UserService service = (UserService)this.getService(etag, UserService.class);
            ResourceAssociationMod associationMod = new ResourceAssociationMod();
            associationMod.getTargetResources().addAll(CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            associationMod.setChangePwd(changepwd);
            associationMod.setPassword(password);
            result = (BulkActionResult)service.bulkAssociation(Long.valueOf(userId), ResourceAssociationActionType.ASSIGN, associationMod).readEntity(BulkActionResult.class);
            this.resetClient(UserService.class);
        }
        return result;
    }
}

