/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.ResourceService;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.types.SubjectType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.common.wrap.SubjectId;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class ResourceRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6898907679835668987L;

    public List<String> getPropagationActionsClasses() {
        List actions = null;
        try {
            actions = CollectionWrapper.unwrap((Collection)((ResourceService)this.getService(ResourceService.class)).getPropagationActionsClasses());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all propagation actions classes", (Throwable)e);
        }
        return actions;
    }

    public List<ResourceTO> getAll() {
        List resources = null;
        try {
            resources = ((ResourceService)this.getService(ResourceService.class)).list();
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all resources", (Throwable)e);
        }
        return resources;
    }

    public void create(ResourceTO resourceTO) {
        ((ResourceService)this.getService(ResourceService.class)).create(resourceTO);
    }

    public ResourceTO read(String name) {
        ResourceTO resourceTO = null;
        try {
            resourceTO = ((ResourceService)this.getService(ResourceService.class)).read(name);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a resource", (Throwable)e);
        }
        return resourceTO;
    }

    public void update(ResourceTO resourceTO) {
        ((ResourceService)this.getService(ResourceService.class)).update(resourceTO.getName(), resourceTO);
    }

    public void delete(String name) {
        ((ResourceService)this.getService(ResourceService.class)).delete(name);
    }

    public BulkActionResult bulkAction(BulkAction action) {
        return ((ResourceService)this.getService(ResourceService.class)).bulk(action);
    }

    public BulkActionResult bulkAssociationAction(String resourceName, Class<? extends AbstractAttributableTO> typeRef, ResourceDeassociationActionType type, List<SubjectId> subjtectIds) {
        return ((ResourceService)this.getService(ResourceService.class)).bulkDeassociation(resourceName, UserTO.class.isAssignableFrom(typeRef) ? SubjectType.USER : SubjectType.ROLE, type, subjtectIds);
    }
}

