/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.ConnectorService;
import org.apache.syncope.common.services.ResourceService;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnIdObjectClassTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.util.BeanUtils;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class ConnectorRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6870366819966266617L;

    public List<ConnInstanceTO> getAllConnectors() {
        List connectors = Collections.emptyList();
        try {
            connectors = ((ConnectorService)this.getService(ConnectorService.class)).list(SyncopeSession.get().getLocale().toString());
        }
        catch (Exception e) {
            LOG.error("While reading connectors", (Throwable)e);
        }
        return connectors;
    }

    public void create(ConnInstanceTO connectorTO) {
        Set filteredConf = this.filterProperties(connectorTO.getConfiguration());
        connectorTO.getConfiguration().clear();
        connectorTO.getConfiguration().addAll(filteredConf);
        ((ConnectorService)this.getService(ConnectorService.class)).create(connectorTO);
    }

    public ConnInstanceTO read(Long connectorInstanceId) {
        ConnInstanceTO connectorTO = null;
        try {
            connectorTO = ((ConnectorService)this.getService(ConnectorService.class)).read(connectorInstanceId);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a connector", (Throwable)e);
        }
        return connectorTO;
    }

    public void update(ConnInstanceTO connectorTO) {
        Set filteredConf = this.filterProperties(connectorTO.getConfiguration());
        connectorTO.getConfiguration().clear();
        connectorTO.getConfiguration().addAll(filteredConf);
        ((ConnectorService)this.getService(ConnectorService.class)).update(Long.valueOf(connectorTO.getId()), connectorTO);
    }

    public ConnInstanceTO delete(Long id) {
        ConnInstanceTO instanceTO = ((ConnectorService)this.getService(ConnectorService.class)).read(id);
        ((ConnectorService)this.getService(ConnectorService.class)).delete(id);
        return instanceTO;
    }

    public List<ConnBundleTO> getAllBundles() {
        List bundles = Collections.emptyList();
        try {
            bundles = ((ConnectorService)this.getService(ConnectorService.class)).getBundles(SyncopeSession.get().getLocale().toString());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }

    public List<ConnConfProperty> getConnectorProperties(Long connectorId) {
        List properties = null;
        try {
            properties = ((ConnectorService)this.getService(ConnectorService.class)).getConfigurationProperties(connectorId);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting connector configuration properties", (Throwable)e);
        }
        return properties;
    }

    private Set<ConnConfProperty> filterProperties(Set<ConnConfProperty> properties) {
        HashSet<ConnConfProperty> newProperties = new HashSet<ConnConfProperty>();
        for (ConnConfProperty property : properties) {
            ConnConfProperty prop = new ConnConfProperty();
            prop.setSchema(property.getSchema());
            prop.setOverridable(property.isOverridable());
            ArrayList parsed = new ArrayList();
            if (property.getValues() != null) {
                for (Object obj : property.getValues()) {
                    if (obj == null || obj.toString().isEmpty()) continue;
                    parsed.add(obj);
                }
            }
            prop.getValues().addAll(parsed);
            newProperties.add(prop);
        }
        return newProperties;
    }

    public boolean check(ConnInstanceTO connectorTO) {
        ConnInstanceTO toBeChecked = new ConnInstanceTO();
        BeanUtils.copyProperties((Object)connectorTO, (Object)toBeChecked, (String[])new String[]{"configuration", "configurationMap"});
        toBeChecked.getConfiguration().addAll(this.filterProperties(connectorTO.getConfiguration()));
        boolean check = false;
        try {
            check = ((ConnectorService)this.getService(ConnectorService.class)).check(toBeChecked);
        }
        catch (Exception e) {
            LOG.error("While checking {}", (Object)toBeChecked, (Object)e);
        }
        return check;
    }

    public boolean check(ResourceTO resourceTO) {
        boolean check = false;
        try {
            check = ((ResourceService)this.getService(ResourceService.class)).check(resourceTO);
        }
        catch (Exception e) {
            LOG.error("Connector not found {}", (Object)resourceTO.getConnectorId(), (Object)e);
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchemaNames(ConnInstanceTO connectorTO) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try {
            List response = ((ConnectorService)this.getService(ConnectorService.class)).getSchemaNames(Long.valueOf(connectorTO.getId()), connectorTO, false);
            for (SchemaTO schema : response) {
                schemaNames.add(schema.getName());
            }
        }
        catch (Exception e) {
            LOG.error("While getting schema names", (Throwable)e);
        }
        finally {
            Collections.sort(schemaNames);
        }
        return schemaNames;
    }

    public List<ConnIdObjectClassTO> getSupportedObjectClasses(ConnInstanceTO connectorTO) {
        List result = Collections.emptyList();
        try {
            result = ((ConnectorService)this.getService(ConnectorService.class)).getSupportedObjectClasses(Long.valueOf(connectorTO.getId()), connectorTO);
        }
        catch (Exception e) {
            LOG.error("While getting supported object classes", (Throwable)e);
        }
        return result;
    }

    public void reload() {
        ((ConnectorService)this.getService(ConnectorService.class)).reload();
    }

    public BulkActionResult bulkAction(BulkAction action) {
        return ((ConnectorService)this.getService(ConnectorService.class)).bulk(action);
    }
}

