/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.services.ConfigurationService;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConfTO;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.rest.BaseRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 7692363064029538722L;
    @Autowired
    private SchemaRestClient schemaRestClient;

    public ConfTO list() {
        ConfTO conf = ((ConfigurationService)this.getService(ConfigurationService.class)).list();
        Iterator it = conf.getAttrs().iterator();
        while (it.hasNext()) {
            AttributeTO attr = (AttributeTO)it.next();
            for (AttrLayoutType type : AttrLayoutType.values()) {
                if (!type.getConfKey().equals(attr.getSchema())) continue;
                it.remove();
            }
        }
        return conf;
    }

    public AttributeTO read(String key) {
        try {
            return ((ConfigurationService)this.getService(ConfigurationService.class)).read(key);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a configuration schema", (Throwable)e);
            return null;
        }
    }

    public AttributeTO readAttrLayout(AttrLayoutType type) {
        if (type == null) {
            return null;
        }
        AttributeTO attrLayout = this.read(type.getConfKey());
        if (attrLayout == null) {
            attrLayout = new AttributeTO();
            attrLayout.setSchema(type.getConfKey());
        }
        if (attrLayout.getValues().isEmpty()) {
            attrLayout.getValues().addAll(this.schemaRestClient.getSchemaNames(type.getAttrType()));
        }
        return attrLayout;
    }

    public void set(AttributeTO attributeTO) {
        ((ConfigurationService)this.getService(ConfigurationService.class)).set(attributeTO.getSchema(), attributeTO);
    }

    public void delete(String key) {
        ((ConfigurationService)this.getService(ConfigurationService.class)).delete(key);
    }

    public List<String> getMailTemplates() {
        return CollectionWrapper.unwrap(new ArrayList(((ConfigurationService)this.getService(ConfigurationService.class)).getMailTemplates()));
    }

    public Response dbExport() {
        return ((ConfigurationService)this.getService(ConfigurationService.class)).export();
    }
}

