/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.pages.DisplayAttributesModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.AttrColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ReflectionUtils;

public class UserSearchResultPanel
extends AbstractSearchResultPanel {
    private static final long serialVersionUID = -905187144506842332L;
    private static final String PAGEID = "Users";
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private final List<String> schemaNames;
    private final List<String> dSchemaNames;

    public <T extends AbstractAttributableTO> UserSearchResultPanel(String id, boolean filtered, String fiql, PageReference callerRef, AbstractSubjectRestClient restClient) {
        super(id, filtered, fiql, callerRef, restClient);
        this.schemaNames = this.schemaRestClient.getSchemaNames(AttributableType.USER);
        this.dSchemaNames = this.schemaRestClient.getDerSchemaNames(AttributableType.USER);
        this.initResultTable();
    }

    protected List<IColumn<AbstractAttributableTO, String>> getColumns() {
        ArrayList<IColumn<AbstractAttributableTO, String>> columns = new ArrayList<IColumn<AbstractAttributableTO, String>>();
        for (String name : this.prefMan.getList(this.getRequest(), "users.details.view")) {
            Field field = ReflectionUtils.findField(UserTO.class, (String)name);
            if ("token".equalsIgnoreCase(name)) {
                columns.add((IColumn<AbstractAttributableTO, String>)new TokenColumn("token"));
                continue;
            }
            if (field != null && field.getType().equals(Date.class)) {
                columns.add((IColumn<AbstractAttributableTO, String>)new DatePropertyColumn((IModel)new ResourceModel(name, name), name, name));
                continue;
            }
            columns.add((IColumn<AbstractAttributableTO, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
        for (String name : this.prefMan.getList(this.getRequest(), "users.attributes.view")) {
            if (!this.schemaNames.contains(name)) continue;
            columns.add((IColumn<AbstractAttributableTO, String>)new AttrColumn(name, SchemaType.NORMAL));
        }
        for (String name : this.prefMan.getList(this.getRequest(), "users.derived.attributes.view")) {
            if (!this.dSchemaNames.contains(name)) continue;
            columns.add((IColumn<AbstractAttributableTO, String>)new AttrColumn(name, SchemaType.DERIVED));
        }
        if (columns.isEmpty()) {
            for (String name : DisplayAttributesModalPage.DEFAULT_SELECTION) {
                columns.add((IColumn<AbstractAttributableTO, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
            }
            this.prefMan.setList(this.getRequest(), this.getResponse(), "users.details.view", Arrays.asList(DisplayAttributesModalPage.DEFAULT_SELECTION));
        }
        columns.add((IColumn<AbstractAttributableTO, String>)new /* Unavailable Anonymous Inner Class!! */);
        return columns;
    }

    protected <T extends AbstractAttributableTO> Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.DELETE);
        bulkActions.add(ActionLink.ActionType.SUSPEND);
        bulkActions.add(ActionLink.ActionType.REACTIVATE);
        return bulkActions;
    }

    protected String getPageId() {
        return PAGEID;
    }

    static /* synthetic */ List access$000(UserSearchResultPanel x0) {
        return x0.schemaNames;
    }

    static /* synthetic */ List access$100(UserSearchResultPanel x0) {
        return x0.dSchemaNames;
    }
}

