/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.to.ConnIdObjectClassTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.MappingItemTO;
import org.apache.syncope.common.to.MappingTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.types.IntMappingType;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.panels.ResourceConnConfPanel;
import org.apache.syncope.console.pages.panels.ResourceMappingPanel;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceMappingPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final String FIELD_STYLE = "ui-widget-content ui-corner-all short_fixedsize";
    private static final String DEF_FIELD_STYLE = "ui-widget-content ui-corner-all";
    private static final String SHORT_FIELD_STYLE = "ui-widget-content ui-corner-all veryshort_fixedsize";
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connRestClient;
    private final List<String> schemaNames;
    private final AjaxButton addMappingBtn;
    private final ListView<MappingItemTO> mappings;
    private final ResourceTO resourceTO;
    private final AttributableType attrType;
    private final WebMarkupContainer mappingContainer;
    private final WebMarkupContainer accountLinkContainer;
    private final AjaxCheckBoxPanel accountLinkCheckbox;

    private MappingTO getMapping() {
        MappingTO result = null;
        if (AttributableType.USER == this.attrType) {
            if (this.resourceTO.getUmapping() == null) {
                this.resourceTO.setUmapping(new MappingTO());
            }
            result = this.resourceTO.getUmapping();
        }
        if (AttributableType.ROLE == this.attrType) {
            if (this.resourceTO.getRmapping() == null) {
                this.resourceTO.setRmapping(new MappingTO());
            }
            result = this.resourceTO.getRmapping();
        }
        return result;
    }

    public ResourceMappingPanel(String id, ResourceTO resourceTO, AttributableType attrType) {
        super(id);
        this.setOutputMarkupId(true);
        this.resourceTO = resourceTO;
        this.attrType = attrType;
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.mappingContainer});
        this.accountLinkContainer = new WebMarkupContainer("accountLinkContainer");
        this.accountLinkContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.accountLinkContainer});
        if (this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L) {
            this.schemaNames = this.getSchemaNames(this.resourceTO.getConnectorId(), this.resourceTO.getConnConfProperties());
            this.setEnabled();
        } else {
            this.schemaNames = Collections.emptyList();
        }
        WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer((String)"jexlHelp");
        AjaxLink questionMarkJexlHelp = JexlHelpUtil.getAjaxLink((WebMarkupContainer)jexlHelp, (String)"questionMarkJexlHelp");
        this.mappingContainer.add(new Component[]{questionMarkJexlHelp});
        questionMarkJexlHelp.add(new Component[]{jexlHelp});
        Label passwordLabel = new Label("passwordLabel", (IModel)new ResourceModel("password"));
        this.mappingContainer.add(new Component[]{passwordLabel});
        if (AttributableType.USER != this.attrType) {
            passwordLabel.setVisible(false);
        }
        Collections.sort(this.getMapping().getItems(), new /* Unavailable Anonymous Inner Class!! */);
        this.mappings = new /* Unavailable Anonymous Inner Class!! */;
        this.mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{this.mappings});
        this.addMappingBtn = new /* Unavailable Anonymous Inner Class!! */;
        this.addMappingBtn.setDefaultFormProcessing(false);
        this.addMappingBtn.setEnabled(this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L);
        this.mappingContainer.add(new Component[]{this.addMappingBtn});
        boolean accountLinkEnabled = false;
        if (this.getMapping().getAccountLink() != null) {
            accountLinkEnabled = true;
        }
        this.accountLinkCheckbox = new AjaxCheckBoxPanel("accountLinkCheckbox", new ResourceModel("accountLinkCheckbox", "accountLinkCheckbox").getObject(), (IModel)new Model((Serializable)Boolean.valueOf(accountLinkEnabled)));
        this.accountLinkCheckbox.setEnabled(true);
        this.accountLinkContainer.add(new Component[]{this.accountLinkCheckbox});
        AjaxTextFieldPanel accountLink = new AjaxTextFieldPanel("accountLink", new ResourceModel("accountLink", "accountLink").getObject(), (IModel)new PropertyModel((Object)this.getMapping(), "accountLink"));
        accountLink.setEnabled(accountLinkEnabled);
        this.accountLinkContainer.add(new Component[]{accountLink});
        this.accountLinkCheckbox.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private List<String> getSchemaNames(Long connectorId, Set<ConnConfProperty> conf) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setId(connectorId.longValue());
        connInstanceTO.getConfiguration().addAll(conf);
        return this.connRestClient.getSchemaNames(connInstanceTO);
    }

    private void setEnabled() {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setId(this.resourceTO.getConnectorId().longValue());
        connInstanceTO.getConfiguration().addAll(this.resourceTO.getConnConfProperties());
        List objectClasses = this.connRestClient.getSupportedObjectClasses(connInstanceTO);
        boolean enabled = objectClasses.isEmpty() || AttributableType.USER == this.attrType && objectClasses.contains(ConnIdObjectClassTO.ACCOUNT) || AttributableType.ROLE == this.attrType && objectClasses.contains(ConnIdObjectClassTO.GROUP);
        this.mappingContainer.setEnabled(enabled);
        this.mappingContainer.setVisible(enabled);
        this.accountLinkContainer.setEnabled(enabled);
        this.accountLinkContainer.setVisible(enabled);
        if (!enabled) {
            this.getMapping().getItems().clear();
            this.getMapping().setAccountLink(null);
            if (this.accountLinkCheckbox != null) {
                this.accountLinkCheckbox.setModelObject(null);
            }
        }
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ResourceConnConfPanel.ConnConfModEvent) {
            AjaxRequestTarget target = ((ResourceConnConfPanel.ConnConfModEvent)event.getPayload()).getTarget();
            List conf = ((ResourceConnConfPanel.ConnConfModEvent)event.getPayload()).getConfiguration();
            this.mappings.removeAll();
            this.addMappingBtn.setEnabled(this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L);
            this.schemaNames.clear();
            this.schemaNames.addAll(this.getSchemaNames(this.resourceTO.getConnectorId(), new HashSet(conf)));
            this.setEnabled();
            target.add(new Component[]{this});
        }
    }

    private void setAttrNames(IntMappingType type, AjaxDropDownChoicePanel<String> toBeUpdated) {
        toBeUpdated.setRequired(true);
        toBeUpdated.setEnabled(true);
        if (type == null || type.getAttributableType() == null) {
            toBeUpdated.setChoices(Collections.emptyList());
        } else {
            switch (5.$SwitchMap$org$apache$syncope$common$types$IntMappingType[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    toBeUpdated.setChoices(this.schemaRestClient.getSchemaNames(type.getAttributableType()));
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    toBeUpdated.setChoices(this.schemaRestClient.getDerSchemaNames(type.getAttributableType()));
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    toBeUpdated.setChoices(this.schemaRestClient.getVirSchemaNames(type.getAttributableType()));
                    break;
                }
                default: {
                    toBeUpdated.setRequired(false);
                    toBeUpdated.setEnabled(false);
                    toBeUpdated.setChoices(Collections.emptyList());
                }
            }
        }
    }

    private void setAccountId(IntMappingType type, AjaxCheckBoxPanel accountId, AjaxCheckBoxPanel password) {
        if (type != null && type.getAttributableType() != null) {
            switch (5.$SwitchMap$org$apache$syncope$common$types$IntMappingType[type.ordinal()]) {
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    accountId.setReadOnly(true);
                    accountId.setModelObject((Object)false);
                    break;
                }
                default: {
                    if (((Boolean)password.getModelObject()).booleanValue()) {
                        accountId.setReadOnly(true);
                        accountId.setModelObject((Object)false);
                        break;
                    }
                    accountId.setReadOnly(false);
                }
            }
        }
    }

    private List<IntMappingType> getAttributeTypes(AttributableType entity) {
        ArrayList<IntMappingType> res = new ArrayList<IntMappingType>();
        if (entity != null) {
            res.addAll(IntMappingType.getAttributeTypes((AttributableType)AttributableType.valueOf((String)entity.name())));
        }
        return res;
    }

    static /* synthetic */ List access$000(ResourceMappingPanel x0, AttributableType x1) {
        return x0.getAttributeTypes(x1);
    }

    static /* synthetic */ MappingTO access$100(ResourceMappingPanel x0) {
        return x0.getMapping();
    }

    static /* synthetic */ List access$200(ResourceMappingPanel x0) {
        return x0.schemaNames;
    }

    static /* synthetic */ void access$300(ResourceMappingPanel x0, IntMappingType x1, AjaxCheckBoxPanel x2, AjaxCheckBoxPanel x3) {
        x0.setAccountId(x1, x2, x3);
    }

    static /* synthetic */ AttributableType access$400(ResourceMappingPanel x0) {
        return x0.attrType;
    }

    static /* synthetic */ void access$500(ResourceMappingPanel x0, IntMappingType x1, AjaxDropDownChoicePanel x2) {
        x0.setAttrNames(x1, x2);
    }

    static /* synthetic */ AjaxCheckBoxPanel access$600(ResourceMappingPanel x0) {
        return x0.accountLinkCheckbox;
    }
}

