/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.console.markup.html.list.ConnConfPropertyListView;
import org.apache.syncope.console.pages.ResourceModalPage;
import org.apache.syncope.console.pages.panels.ResourceConnConfPanel;
import org.apache.syncope.console.pages.panels.ResourceDetailsPanel;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceConnConfPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private ConnectorRestClient restClient;
    private final ResourceTO resourceTO;
    private final boolean createFlag;
    private List<ConnConfProperty> connConfProperties;
    private WebMarkupContainer connConfPropContainer;
    private AjaxButton check;

    public ResourceConnConfPanel(String id, ResourceTO resourceTO, boolean createFlag) {
        super(id);
        this.setOutputMarkupId(true);
        this.createFlag = createFlag;
        this.resourceTO = resourceTO;
        this.connConfProperties = this.getConnConfProperties();
        this.connConfPropContainer = new WebMarkupContainer("connectorPropertiesContainer");
        this.connConfPropContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.connConfPropContainer});
        ConnConfPropertyListView connPropView = new ConnConfPropertyListView("connectorProperties", (IModel)new PropertyModel((Object)this, "connConfProperties"), false, resourceTO.getConnConfProperties());
        connPropView.setOutputMarkupId(true);
        this.connConfPropContainer.add(new Component[]{connPropView});
        this.check = new /* Unavailable Anonymous Inner Class!! */;
        this.check.setEnabled(!this.connConfProperties.isEmpty());
        this.connConfPropContainer.add(new Component[]{this.check});
    }

    private List<ConnConfProperty> getConnConfProperties() {
        ArrayList<ConnConfProperty> props = new ArrayList<ConnConfProperty>();
        Long connectorId = this.resourceTO.getConnectorId();
        if (connectorId != null && connectorId > 0L) {
            for (ConnConfProperty property : this.restClient.getConnectorProperties(connectorId)) {
                if (!property.isOverridable()) continue;
                props.add(property);
            }
        }
        if (this.createFlag || this.resourceTO.getConnConfProperties().isEmpty()) {
            this.resourceTO.getConnConfProperties().clear();
        } else {
            HashMap<String, ConnConfProperty> valuedProps = new HashMap<String, ConnConfProperty>();
            for (ConnConfProperty prop : this.resourceTO.getConnConfProperties()) {
                valuedProps.put(prop.getSchema().getName(), prop);
            }
            for (int i = 0; i < props.size(); ++i) {
                if (!valuedProps.containsKey(((ConnConfProperty)props.get(i)).getSchema().getName())) continue;
                props.set(i, (ConnConfProperty)valuedProps.get(((ConnConfProperty)props.get(i)).getSchema().getName()));
            }
        }
        Collections.sort(props);
        return props;
    }

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target = null;
        if (event.getPayload() instanceof ResourceDetailsPanel.DetailsModEvent) {
            target = ((ResourceModalPage.ResourceEvent)event.getPayload()).getTarget();
            this.connConfProperties = this.getConnConfProperties();
            this.check.setEnabled(!this.connConfProperties.isEmpty());
            target.add(new Component[]{this.connConfPropContainer});
        } else if (event.getPayload() instanceof MultiFieldPanel.MultiValueSelectorEvent) {
            target = ((MultiFieldPanel.MultiValueSelectorEvent)event.getPayload()).getTarget();
        }
        if (target != null) {
            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, (Object)new ConnConfModEvent(target, this.connConfProperties));
        }
    }

    static /* synthetic */ ConnectorRestClient access$000(ResourceConnConfPanel x0) {
        return x0.restClient;
    }
}

