/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.console.pages.panels.EventSelectionPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventSelectionPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(EventSelectionPanel.class);
    private static final long serialVersionUID = 752233163798301002L;
    private final Set<String> selected = new HashSet();

    public EventSelectionPanel(String id, EventCategoryTO eventCategoryTO, IModel<List<String>> model) {
        super(id);
        this.setOutputMarkupId(true);
        List events = this.getEvents(eventCategoryTO);
        this.selected.addAll((Collection)model.getObject());
        CheckGroup successGroup = new CheckGroup("successGroup", (Collection)this.selected);
        successGroup.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        successGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{successGroup});
        this.add(new Component[]{new Label("successLabel", (IModel)new ResourceModel("Success", "Success"))}).setVisible(!events.isEmpty());
        CheckGroupSelector successSelector = new CheckGroupSelector("successSelector", successGroup);
        successSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{successSelector});
        2 categoryView = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{categoryView});
        3 successView = new /* Unavailable Anonymous Inner Class!! */;
        successGroup.add(new Component[]{successView});
        CheckGroup failureGroup = new CheckGroup("failureGroup", (Collection)this.selected);
        failureGroup.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        failureGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{failureGroup});
        this.add(new Component[]{new Label("failureLabel", (IModel)new ResourceModel("Failure", "Failure"))}).setVisible(!events.isEmpty());
        CheckGroupSelector failureSelector = new CheckGroupSelector("failureSelector", failureGroup);
        failureSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{failureSelector});
        5 failureView = new /* Unavailable Anonymous Inner Class!! */;
        failureGroup.add(new Component[]{failureView});
    }

    private List<String> getEvents(EventCategoryTO eventCategoryTO) {
        List res = eventCategoryTO.getEvents();
        if (res.isEmpty()) {
            if ((AuditElements.EventCategoryType.PROPAGATION == eventCategoryTO.getType() || AuditElements.EventCategoryType.SYNCHRONIZATION == eventCategoryTO.getType() || AuditElements.EventCategoryType.PUSH == eventCategoryTO.getType()) && StringUtils.isEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getType().toString());
            } else if (AuditElements.EventCategoryType.TASK == eventCategoryTO.getType() && StringUtils.isNotEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getCategory());
            }
        } else {
            Collections.sort(res);
        }
        return res;
    }

    protected abstract void onEventAction(IEvent<?> var1);

    public void onEvent(IEvent<?> event) {
        this.onEventAction(event);
    }

    static /* synthetic */ List access$000(EventSelectionPanel x0, EventCategoryTO x1) {
        return x0.getEvents(x1);
    }
}

