/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConfTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.AttributeSchemaType;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.pages.panels.AttributesPanel;
import org.apache.syncope.console.rest.ConfigurationRestClient;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDoubleFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AttributesPanel
extends Panel {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConfigurationRestClient confRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final AbstractAttributableTO entityTO;
    private final Mode mode;
    private final AttrTemplatesPanel attrTemplates;
    private Map<String, SchemaTO> schemas = new LinkedHashMap();

    public <T extends AbstractAttributableTO> AttributesPanel(String id, T entityTO, Form form, Mode mode) {
        this(id, entityTO, form, mode, null);
    }

    public <T extends AbstractAttributableTO> AttributesPanel(String id, T entityTO, Form form, Mode mode, AttrTemplatesPanel attrTemplates) {
        super(id);
        this.entityTO = entityTO;
        this.mode = mode;
        this.attrTemplates = attrTemplates;
        this.setOutputMarkupId(true);
        this.setSchemas();
        this.setAttrs();
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void setSchemas() {
        List schemaTOs;
        AttributeTO attrLayout = null;
        if (this.entityTO instanceof RoleTO) {
            HashSet allowed;
            RoleTO roleTO = (RoleTO)this.entityTO;
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf((Mode)this.mode, (AttributableType)AttributableType.ROLE));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.ROLE);
            if (this.attrTemplates == null) {
                allowed = new HashSet(roleTO.getRAttrTemplates());
            } else {
                allowed = new HashSet(this.attrTemplates.getSelected(AttrTemplatesPanel.Type.rAttrTemplates));
                if (roleTO.isInheritTemplates() && roleTO.getParent() != 0L) {
                    allowed.addAll(this.roleRestClient.read(Long.valueOf(roleTO.getParent())).getRAttrTemplates());
                }
            }
            this.schemaRestClient.filter(schemaTOs, allowed, true);
        } else if (this.entityTO instanceof UserTO) {
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf((Mode)this.mode, (AttributableType)AttributableType.USER));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.USER);
        } else if (this.entityTO instanceof MembershipTO) {
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf((Mode)this.mode, (AttributableType)AttributableType.MEMBERSHIP));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.MEMBERSHIP);
            HashSet allowed = new HashSet(this.roleRestClient.read(Long.valueOf(((MembershipTO)this.entityTO).getRoleId())).getMAttrTemplates());
            this.schemaRestClient.filter(schemaTOs, allowed, true);
        } else {
            this.schemas = new TreeMap();
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.CONFIGURATION);
            Iterator it = schemaTOs.iterator();
            while (it.hasNext()) {
                SchemaTO schemaTO = (SchemaTO)it.next();
                for (AttrLayoutType type : AttrLayoutType.values()) {
                    if (!type.getConfKey().equals(schemaTO.getName())) continue;
                    it.remove();
                }
            }
        }
        this.schemas.clear();
        if (attrLayout != null && this.mode != Mode.TEMPLATE && !(this.entityTO instanceof ConfTO)) {
            this.schemaRestClient.filter(schemaTOs, (Collection)attrLayout.getValues(), true);
            HashMap attrLayoutMap = new HashMap(attrLayout.getValues().size());
            for (int i = 0; i < attrLayout.getValues().size(); ++i) {
                attrLayoutMap.put(attrLayout.getValues().get(i), i);
            }
            Collections.sort(schemaTOs, new /* Unavailable Anonymous Inner Class!! */);
        }
        for (SchemaTO schemaTO : schemaTOs) {
            this.schemas.put(schemaTO.getName(), schemaTO);
        }
    }

    private void setAttrs() {
        ArrayList<AttributeTO> entityData = new ArrayList<AttributeTO>();
        Map attrMap = this.entityTO.getAttrMap();
        for (SchemaTO schema : this.schemas.values()) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(schema.getName());
            if (attrMap.get(schema.getName()) == null || ((AttributeTO)attrMap.get(schema.getName())).getValues().isEmpty()) {
                attributeTO.getValues().add("");
                attributeTO.setReadonly(schema.isReadonly());
            } else {
                attributeTO.getValues().addAll(((AttributeTO)attrMap.get(schema.getName())).getValues());
            }
            entityData.add(attributeTO);
        }
        this.entityTO.getAttrs().clear();
        this.entityTO.getAttrs().addAll(entityData);
    }

    private FieldPanel getFieldPanel(SchemaTO schemaTO, Form form, AttributeTO attributeTO) {
        AjaxCheckBoxPanel panel;
        boolean required = this.mode == Mode.TEMPLATE ? false : schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = this.mode == Mode.TEMPLATE ? false : schemaTO.isReadonly();
        AttributeSchemaType type = this.mode == Mode.TEMPLATE ? AttributeSchemaType.String : schemaTO.getType();
        switch (4.$SwitchMap$org$apache$syncope$common$types$AttributeSchemaType[type.ordinal()]) {
            case 1: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel)new Model());
                panel.setRequired(required);
                break;
            }
            case 2: {
                String dataPattern;
                String string = dataPattern = schemaTO.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : schemaTO.getConversionPattern();
                if (dataPattern.contains("H")) {
                    panel = new DateTimeFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), dataPattern);
                    if (required) {
                        panel.addRequiredLabel();
                        ((DateTimeFieldPanel)panel).setFormValidator(form);
                    }
                    panel.setStyleSheet("ui-widget-content ui-corner-all");
                    break;
                }
                panel = new DateTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), dataPattern);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case 3: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model());
                ((AjaxDropDownChoicePanel)panel).setChoices(this.getEnumeratedValues(schemaTO));
                if (StringUtils.isNotBlank((CharSequence)schemaTO.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case 4: {
                panel = new SpinnerFieldPanel("panel", schemaTO.getName(), Long.class, (IModel)new Model(), null, null);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case 5: {
                panel = new AjaxDoubleFieldPanel("panel", schemaTO.getName(), schemaTO.getConversionPattern(), (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case 6: {
                panel = new BinaryFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), this.schemas.containsKey(schemaTO.getName()) ? ((SchemaTO)this.schemas.get(schemaTO.getName())).getMimeType() : null);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setNewModel(attributeTO.getValues());
        return panel;
    }

    private Map<String, String> getEnumeratedKeyValues(SchemaTO schemaTO) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] values = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationValues()) ? new String[]{} : schemaTO.getEnumerationValues().split(";");
        String[] keys = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationKeys()) ? new String[]{} : schemaTO.getEnumerationKeys().split(";");
        for (int i = 0; i < values.length; ++i) {
            res.put(values[i].trim(), keys.length > i ? keys[i].trim() : null);
        }
        return res;
    }

    private List<String> getEnumeratedValues(SchemaTO schemaTO) {
        String[] values;
        ArrayList<String> res = new ArrayList<String>();
        for (String value : values = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationValues()) ? new String[]{} : schemaTO.getEnumerationValues().split(";")) {
            res.add(value.trim());
        }
        return res;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AttrTemplatesPanel.RoleAttrTemplatesChange) {
            AttrTemplatesPanel.RoleAttrTemplatesChange update = (AttrTemplatesPanel.RoleAttrTemplatesChange)event.getPayload();
            if (this.attrTemplates != null && update.getType() == AttrTemplatesPanel.Type.rAttrTemplates) {
                this.setSchemas();
                this.setAttrs();
                update.getTarget().add(new Component[]{this});
            }
        }
    }

    static /* synthetic */ Map access$000(AttributesPanel x0) {
        return x0.schemas;
    }

    static /* synthetic */ FieldPanel access$100(AttributesPanel x0, SchemaTO x1, Form x2, AttributeTO x3) {
        return x0.getFieldPanel(x1, x2, x3);
    }

    static /* synthetic */ Map access$200(AttributesPanel x0, SchemaTO x1) {
        return x0.getEnumeratedKeyValues(x1);
    }
}

