/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.console.commons.AttributableDataProvider;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.rest.BaseRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSource;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchResultPanel
extends Panel
implements IEventSource {
    private static final long serialVersionUID = -9170191461250434024L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSearchResultPanel.class);
    private static final int EDIT_MODAL_WIN_HEIGHT = 550;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    private static final int DISPLAYATTRS_MODAL_WIN_HEIGHT = 550;
    private static final int DISPLAYATTRS_MODAL_WIN_WIDTH = 550;
    private static final int STATUS_MODAL_WIN_HEIGHT = 500;
    private static final int STATUS_MODAL_WIN_WIDTH = 700;
    @SpringBean
    protected PreferenceManager prefMan;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    protected final AbstractSubjectRestClient restClient;
    private final int rows;
    protected final WebMarkupContainer container;
    protected final NotificationPanel feedbackPanel;
    private final boolean filtered;
    private String fiql;
    private AjaxDataTablePanel<AbstractAttributableTO, String> resultTable;
    private AttributableDataProvider dataProvider;
    protected final ModalWindow editmodal = new ModalWindow("editModal");
    protected final ModalWindow displaymodal = new ModalWindow("displayModal");
    protected final ModalWindow statusmodal = new ModalWindow("statusModal");
    protected final AbstractBasePage page;

    protected <T extends AbstractAttributableTO> AbstractSearchResultPanel(String id, boolean filtered, String fiql, PageReference pageRef, AbstractSubjectRestClient restClient) {
        super(id);
        this.setOutputMarkupId(true);
        this.page = (AbstractBasePage)pageRef.getPage();
        this.filtered = filtered;
        this.fiql = fiql;
        this.feedbackPanel = this.page.getFeedbackPanel();
        this.restClient = restClient;
        this.editmodal.setCssClassName("w_silver");
        this.editmodal.setInitialHeight(550);
        this.editmodal.setInitialWidth(800);
        this.editmodal.setCookieName("edit-modal");
        this.add(new Component[]{this.editmodal});
        this.displaymodal.setCssClassName("w_silver");
        this.displaymodal.setInitialHeight(550);
        this.displaymodal.setInitialWidth(550);
        this.displaymodal.setCookieName("display-modal");
        this.add(new Component[]{this.displaymodal});
        this.statusmodal.setCssClassName("w_silver");
        this.statusmodal.setInitialHeight(500);
        this.statusmodal.setInitialWidth(700);
        this.statusmodal.setCookieName("status-modal");
        this.add(new Component[]{this.statusmodal});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.rows = this.prefMan.getPaginatorRows(this.getRequest(), "users.paginator.rows");
    }

    protected void initResultTable() {
        this.updateResultTable(false);
        Form paginatorForm = new Form("paginator");
        this.container.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.setWindowClosedReloadCallback(this.statusmodal);
        this.setWindowClosedReloadCallback(this.editmodal);
        this.setWindowClosedReloadCallback(this.displaymodal);
    }

    public void search(String fiql, AjaxRequestTarget target) {
        this.fiql = fiql;
        this.dataProvider.setFIQL(fiql);
        target.add(new Component[]{this.container});
    }

    private void updateResultTable(boolean create) {
        this.updateResultTable(create, this.rows);
    }

    private void updateResultTable(boolean create, int rows) {
        this.dataProvider = new AttributableDataProvider(this.restClient, rows, this.filtered);
        this.dataProvider.setFIQL(this.fiql);
        int currentPage = this.resultTable != null ? (create ? (int)this.resultTable.getPageCount() - 1 : (int)this.resultTable.getCurrentPage()) : 0;
        this.resultTable = new AjaxDataTablePanel("resultTable", this.getColumns(), (ISortableDataProvider)this.dataProvider, rows, this.getBulkActions(), (BaseRestClient)this.restClient, "id", this.getPageId(), this.page.getPageReference());
        this.resultTable.setCurrentPage((long)currentPage);
        this.resultTable.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{this.resultTable});
    }

    protected abstract List<IColumn<AbstractAttributableTO, String>> getColumns();

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof EventDataWrapper) {
            EventDataWrapper data = (EventDataWrapper)event.getPayload();
            if (data.getRows() < 1) {
                this.updateResultTable(data.isCreate());
            } else {
                this.updateResultTable(data.isCreate(), data.getRows());
            }
            data.getTarget().add(new Component[]{this.container});
        }
    }

    private void setWindowClosedReloadCallback(ModalWindow window) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract <T extends AbstractAttributableTO> Collection<ActionLink.ActionType> getBulkActions();

    protected abstract String getPageId();

    static /* synthetic */ int access$000(AbstractSearchResultPanel x0) {
        return x0.rows;
    }
}

