/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.AbstractStatusModalPage;
import org.apache.syncope.console.pages.StatusModalPage;
import org.apache.syncope.console.pages.panels.ActionDataTablePanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class StatusModalPage<T extends AbstractSubjectTO>
extends AbstractStatusModalPage {
    private static final long serialVersionUID = -9148734710505211261L;
    private final AbstractSubjectTO subjectTO;
    private int rowsPerPage = 10;
    final StatusUtils statusUtils;
    final boolean statusOnly;
    final ClearIndicatingAjaxButton cancel;
    final WebMarkupContainer pwdMgt;
    final Form<?> pwdMgtForm;
    final AjaxCheckBoxPanel changepwd;
    final PasswordTextField password;
    final PasswordTextField confirm;
    final PageReference pageRef;
    final ModalWindow window;
    final ActionDataTablePanel<StatusBean, String> table;
    final List<IColumn<StatusBean, String>> columns;

    public StatusModalPage(PageReference pageRef, ModalWindow window, AbstractSubjectTO attributableTO) {
        this(pageRef, window, attributableTO, false);
    }

    public StatusModalPage(PageReference pageRef, ModalWindow window, AbstractSubjectTO subjectTO, boolean statusOnly) {
        this.pageRef = pageRef;
        this.window = window;
        this.statusOnly = statusOnly;
        this.subjectTO = subjectTO;
        this.statusUtils = new StatusUtils((AbstractSubjectRestClient)(subjectTO instanceof UserTO ? this.userRestClient : this.roleRestClient));
        this.columns = new ArrayList();
        this.columns.add(new /* Unavailable Anonymous Inner Class!! */);
        this.columns.add(new PropertyColumn((IModel)new StringResourceModel("accountLink", (Component)this, null, "Account link", new Object[0]), (Object)"accountLink", "accountLink"));
        this.columns.add(new /* Unavailable Anonymous Inner Class!! */);
        this.table = new /* Unavailable Anonymous Inner Class!! */;
        this.table.setOutputMarkupId(true);
        String pageId = subjectTO instanceof RoleTO ? "Roles" : "Users";
        Fragment pwdMgtFragment = new Fragment("pwdMgtFields", "pwdMgtFragment", (MarkupContainer)this);
        this.addOrReplace(new Component[]{pwdMgtFragment});
        this.pwdMgt = new WebMarkupContainer("pwdMgt");
        pwdMgtFragment.add(new Component[]{this.pwdMgt.setOutputMarkupId(true)});
        this.pwdMgtForm = new Form("pwdMgtForm");
        this.pwdMgtForm.setVisible(false).setEnabled(false);
        this.pwdMgt.add(new Component[]{this.pwdMgtForm});
        this.password = new PasswordTextField("password", (IModel)new Model());
        this.pwdMgtForm.add(new Component[]{this.password.setRequired(false).setEnabled(false)});
        this.confirm = new PasswordTextField("confirm", (IModel)new Model());
        this.pwdMgtForm.add(new Component[]{this.confirm.setRequired(false).setEnabled(false)});
        this.changepwd = new AjaxCheckBoxPanel("changepwd", "changepwd", (IModel)new Model((Serializable)Boolean.valueOf(false)));
        this.pwdMgtForm.add(new Component[]{this.changepwd.setModelObject((Object)false)});
        this.pwdMgtForm.add(new Component[]{new Label("changePwdLabel", (IModel)new ResourceModel("changePwdLabel", "Password propagation"))});
        this.changepwd.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.cancel = new /* Unavailable Anonymous Inner Class!! */.feedbackPanelAutomaticReload(false);
        this.pwdMgtForm.add(new Component[]{this.cancel});
        6 goon = new /* Unavailable Anonymous Inner Class!! */;
        this.pwdMgtForm.add(new Component[]{goon});
        if (statusOnly) {
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.REACTIVATE, pageId);
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.SUSPEND, pageId);
        } else {
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.UNLINK, pageId);
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.LINK, pageId);
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.DEPROVISION, pageId);
            this.table.addAction(new /* Unavailable Anonymous Inner Class!! */.feedbackPanelAutomaticReload(!(subjectTO instanceof UserTO)), ActionLink.ActionType.PROVISION, pageId);
            this.table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.UNASSIGN, pageId);
            this.table.addAction(new /* Unavailable Anonymous Inner Class!! */.feedbackPanelAutomaticReload(!(subjectTO instanceof UserTO)), ActionLink.ActionType.ASSIGN, pageId);
        }
        this.table.addCancelButton(window);
        this.add(new Component[]{this.table});
    }

    private void passwordManagement(AjaxRequestTarget target, ResourceAssociationActionType type, Collection<StatusBean> selection) {
        ClearIndicatingAjaxButton goon = new /* Unavailable Anonymous Inner Class!! */.feedbackPanelAutomaticReload(false);
        this.pwdMgtForm.addOrReplace(new Component[]{goon});
        this.table.setVisible(false);
        this.pwdMgtForm.setVisible(true).setEnabled(true);
        target.add(new Component[]{this.table});
        target.add(new Component[]{this.pwdMgt});
    }

    private List<StatusBean> getStatusBeans(Collection<StatusBean> selection) {
        ArrayList<String> resources = new ArrayList<String>(selection.size());
        for (StatusBean statusBean : selection) {
            resources.add(statusBean.getResourceName());
        }
        List connObjects = this.statusUtils.getConnectorObjects(Collections.singletonList(this.subjectTO), resources);
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size());
        for (ConnObjectWrapper entry : connObjects) {
            StatusBean statusBean = "Syncope".equals(entry.getResourceName()) ? this.getCurrentSyncopeStatusBean() : this.statusUtils.getStatusBean((AbstractAttributableTO)this.subjectTO, entry.getResourceName(), entry.getConnObjectTO(), this.subjectTO instanceof RoleTO);
            statusBeans.add(statusBean);
        }
        return statusBeans;
    }

    private StatusBean getCurrentSyncopeStatusBean() {
        StatusBean syncope = new StatusBean((AbstractAttributableTO)this.subjectTO, "Syncope");
        syncope.setAccountLink(((UserTO)this.subjectTO).getUsername());
        Status syncopeStatus = Status.UNDEFINED;
        try {
            syncopeStatus = Status.valueOf((String)this.userRestClient.read(Long.valueOf(this.subjectTO.getId())).getStatus().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unexpected status found: {}", (Object)((UserTO)this.subjectTO).getStatus(), (Object)e);
        }
        syncope.setStatus(syncopeStatus);
        return syncope;
    }

    static /* synthetic */ List access$000(StatusModalPage x0, Collection x1) {
        return x0.getStatusBeans(x1);
    }

    static /* synthetic */ void access$100(StatusModalPage x0, AjaxRequestTarget x1, ResourceAssociationActionType x2, Collection x3) {
        x0.passwordManagement(x1, x2, x3);
    }

    static /* synthetic */ AbstractSubjectTO access$200(StatusModalPage x0) {
        return x0.subjectTO;
    }
}

