/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.Reports;
import org.apache.syncope.console.rest.JobRestClient;
import org.apache.syncope.console.rest.LoggerRestClient;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.JobColumn;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Reports
extends BasePage {
    private static final long serialVersionUID = -2071214196989178694L;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 700;
    @SpringBean
    private LoggerRestClient loggerRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private WebMarkupContainer reportContainer;
    private WebMarkupContainer auditContainer;
    private int paginatorRows;
    private final ModalWindow window = new ModalWindow("reportWin");

    public Reports(PageParameters parameters) {
        super(parameters);
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-report-win");
        this.add(new Component[]{this.window});
        this.setupReport();
        this.setupAudit();
    }

    private void setupReport() {
        this.reportContainer = new WebMarkupContainer("reportContainer");
        this.setWindowClosedCallback(this.window, this.reportContainer);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.reportContainer, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "list"));
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "report.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("lastExec"), "lastExec", "lastExec"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("nextExec"), "nextExec", "nextExec"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("latestExecStatus"), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add(new JobColumn((IModel)new StringResourceModel("", (Component)this, null, "", new Object[0]), (Object)"runtime", this.getPageReference(), (JobRestClient)this.reportRestClient));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable reportTable = new AjaxFallbackDefaultDataTable("reportTable", columns, (ISortableDataProvider)new ReportProvider(this), this.paginatorRows);
        this.reportContainer.add(new Component[]{reportTable});
        this.reportContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.reportContainer});
        Form paginatorForm = new Form("paginatorForm");
        MetaDataRoleAuthorizationStrategy.authorize((Component)paginatorForm, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "list"));
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        3 createLink = new /* Unavailable Anonymous Inner Class!! */;
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "create"));
        this.add(new Component[]{createLink});
    }

    private void setupAudit() {
        this.auditContainer = new WebMarkupContainer("auditContainer");
        this.auditContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.auditContainer});
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.auditContainer, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Audit", "list"));
        Form form = new Form("auditForm");
        this.auditContainer.add(new Component[]{form});
        ArrayList<String> events = new ArrayList<String>();
        List audits = this.loggerRestClient.listAudits();
        for (AuditLoggerName audit : audits) {
            events.add(LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)audit.getType(), (String)audit.getCategory(), (String)audit.getSubcategory(), (String)audit.getEvent(), (AuditElements.Result)audit.getResult()));
        }
        ListModel model = new ListModel(new ArrayList(events));
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public String getAjaxIndicatorMarkupId() {
        return "";
    }

    static /* synthetic */ ModalWindow access$000(Reports x0) {
        return x0.window;
    }

    static /* synthetic */ WebMarkupContainer access$100(Reports x0) {
        return x0.reportContainer;
    }

    static /* synthetic */ int access$200(Reports x0) {
        return x0.paginatorRows;
    }

    static /* synthetic */ PreferenceManager access$300(Reports x0) {
        return x0.prefMan;
    }

    static /* synthetic */ LoggerRestClient access$400(Reports x0) {
        return x0.loggerRestClient;
    }
}

