/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.report.AbstractReportletConf;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.ReportExecExportFormat;
import org.apache.syncope.console.commons.DateFormatROModel;
import org.apache.syncope.console.markup.html.CrontabContainer;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ReportModalPage;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class ReportModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -5747628615211127644L;
    private static final String ADD_BUTTON_ID = "addButton";
    private static final String EDIT_BUTTON_ID = "editButton";
    private static final String REMOVE_BUTTON_ID = "removeButton";
    private static final String UP_BUTTON_ID = "upButton";
    private static final String DOWN_BUTTON_ID = "downButton";
    private static final int EXEC_EXPORT_WIN_HEIGHT = 100;
    private static final int EXEC_EXPORT_WIN_WIDTH = 400;
    private static final int REPORTLET_CONF_WIN_HEIGHT = 500;
    private static final int REPORTLET_CONF_WIN_WIDTH = 800;
    private final ReportTO reportTO;
    private final Form<ReportTO> form;
    private ReportExecExportFormat exportFormat;
    private long exportExecId;
    private AbstractReportletConf modalReportletConf;
    private String modalReportletConfOldName;
    private ListChoice<AbstractReportletConf> reportlets;

    public ReportModalPage(ModalWindow window, ReportTO reportTO, PageReference callerPageRef) {
        this.reportTO = reportTO;
        this.form = new Form("form");
        this.form.setModel((IModel)new CompoundPropertyModel((Object)reportTO));
        this.add(new Component[]{this.form});
        this.setupProfile();
        this.setupExecutions();
        CrontabContainer crontab = new CrontabContainer("crontab", new PropertyModel((Object)reportTO, "cronExpression"), reportTO.getCronExpression());
        this.form.add(new Component[]{crontab});
        1 submit = new /* Unavailable Anonymous Inner Class!! */;
        if (reportTO.getId() > 0L) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "update"));
        } else {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "create"));
        }
        this.form.add(new Component[]{submit});
        2 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        this.form.add(new Component[]{cancel});
    }

    private void setupProfile() {
        WebMarkupContainer profile = new WebMarkupContainer("profile");
        profile.setOutputMarkupId(true);
        this.form.add(new Component[]{profile});
        ModalWindow reportletConfWin = new ModalWindow("reportletConfWin");
        reportletConfWin.setCssClassName("w_silver");
        reportletConfWin.setCookieName("reportlet-conf-win-modal");
        reportletConfWin.setInitialHeight(500);
        reportletConfWin.setInitialWidth(800);
        reportletConfWin.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{reportletConfWin});
        Label idLabel = new Label("idLabel", (IModel)new ResourceModel("id"));
        profile.add(new Component[]{idLabel});
        AjaxTextFieldPanel id = new AjaxTextFieldPanel("id", this.getString("id"), (IModel)new PropertyModel((Object)this.reportTO, "id"));
        id.setEnabled(false);
        profile.add(new Component[]{id});
        Label nameLabel = new Label("nameLabel", (IModel)new ResourceModel("name"));
        profile.add(new Component[]{nameLabel});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel)new PropertyModel((Object)this.reportTO, "name"));
        profile.add(new Component[]{name});
        AjaxTextFieldPanel lastExec = new AjaxTextFieldPanel("lastExec", this.getString("lastExec"), (IModel)new DateFormatROModel(new PropertyModel((Object)this.reportTO, "lastExec")));
        lastExec.setEnabled(false);
        profile.add(new Component[]{lastExec});
        AjaxTextFieldPanel nextExec = new AjaxTextFieldPanel("nextExec", this.getString("nextExec"), (IModel)new DateFormatROModel(new PropertyModel((Object)this.reportTO, "nextExec")));
        nextExec.setEnabled(false);
        profile.add(new Component[]{nextExec});
        this.reportlets = new /* Unavailable Anonymous Inner Class!! */;
        this.reportlets.setNullValid(true);
        profile.add(new Component[]{this.reportlets});
        this.reportlets.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        profile.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        profile.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        profile.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        profile.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        profile.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void moveUp(AbstractReportletConf item) {
        List list = this.reportTO.getReportletConfs();
        int newPosition = list.indexOf(item) - 1;
        if (newPosition > -1) {
            list.remove(item);
            list.add(newPosition, item);
        }
    }

    private void moveDown(AbstractReportletConf item) {
        List list = this.reportTO.getReportletConfs();
        int newPosition = list.indexOf(item) + 1;
        if (newPosition < list.size()) {
            list.remove(item);
            list.add(newPosition, item);
        }
    }

    private void setupExecutions() {
        WebMarkupContainer executions = new WebMarkupContainer("executionContainer");
        executions.setOutputMarkupId(true);
        this.form.add(new Component[]{executions});
        ModalWindow reportExecMessageWin = new ModalWindow("reportExecMessageWin");
        reportExecMessageWin.setCssClassName("w_silver");
        reportExecMessageWin.setCookieName("report-exec-message-win-modal");
        this.add(new Component[]{reportExecMessageWin});
        ModalWindow reportExecExportWin = new ModalWindow("reportExecExportWin");
        reportExecExportWin.setCssClassName("w_silver");
        reportExecExportWin.setCookieName("report-exec-export-win-modal");
        reportExecExportWin.setInitialHeight(100);
        reportExecExportWin.setInitialWidth(400);
        reportExecExportWin.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{reportExecExportWin});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add(new DatePropertyColumn((IModel)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("status"), (Object)"status", "status"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new ReportExecutionsProvider(this.reportTO), 10);
        executions.add(new Component[]{table});
    }

    public void setExportFormat(ReportExecExportFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public void setModalReportletConf(AbstractReportletConf modalReportletConf) {
        this.modalReportletConf = modalReportletConf;
    }

    static /* synthetic */ String access$000(ReportModalPage x0) {
        return x0.modalReportletConfOldName;
    }

    static /* synthetic */ ReportTO access$100(ReportModalPage x0) {
        return x0.reportTO;
    }

    static /* synthetic */ AbstractReportletConf access$200(ReportModalPage x0) {
        return x0.modalReportletConf;
    }

    static /* synthetic */ ListChoice access$300(ReportModalPage x0) {
        return x0.reportlets;
    }

    static /* synthetic */ String access$002(ReportModalPage x0, String x1) {
        x0.modalReportletConfOldName = x1;
        return x0.modalReportletConfOldName;
    }

    static /* synthetic */ AbstractReportletConf access$202(ReportModalPage x0, AbstractReportletConf x1) {
        x0.modalReportletConf = x1;
        return x0.modalReportletConf;
    }

    static /* synthetic */ void access$400(ReportModalPage x0, AbstractReportletConf x1) {
        x0.moveUp(x1);
    }

    static /* synthetic */ void access$500(ReportModalPage x0, AbstractReportletConf x1) {
        x0.moveDown(x1);
    }

    static /* synthetic */ ReportExecExportFormat access$600(ReportModalPage x0) {
        return x0.exportFormat;
    }

    static /* synthetic */ long access$700(ReportModalPage x0) {
        return x0.exportExecId;
    }

    static /* synthetic */ long access$702(ReportModalPage x0, long x1) {
        x0.exportExecId = x1;
        return x0.exportExecId;
    }
}

