/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.wrap.AbstractWrappable;
import org.apache.syncope.common.wrap.SubjectId;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.AbstractStatusModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.BulkActionResultModalPage;
import org.apache.syncope.console.pages.ProvisioningModalPage;
import org.apache.syncope.console.pages.panels.ActionDataTablePanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ProvisioningModalPage<T extends AbstractAttributableTO>
extends AbstractStatusModalPage {
    private static final long serialVersionUID = -4285220460543213901L;
    private static final int ROWS_PER_PAGE = 10;
    private final ResourceTO resourceTO;
    private final Class<? extends AbstractAttributableTO> typeRef;
    private final PageReference pageRef;
    private final ModalWindow window;
    private final StatusUtils statusUtils;

    public ProvisioningModalPage(PageReference pageRef, ModalWindow window, ResourceTO resourceTO, Class<T> typeRef) {
        this.pageRef = pageRef;
        this.window = window;
        this.resourceTO = resourceTO;
        this.typeRef = typeRef;
        this.statusUtils = new StatusUtils((AbstractSubjectRestClient)(UserTO.class.isAssignableFrom(typeRef) ? this.userRestClient : this.roleRestClient));
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, "Attributable id", new Object[0]), (Object)"attributableId", "attributableId"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, "Attributable name", new Object[0]), (Object)"attributableName", "attributableName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("resourceName", (Component)this, null, "Resource name", new Object[0]), (Object)"resourceName", "resourceName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("accountLink", (Component)this, null, "Account link", new Object[0]), (Object)"accountLink", "accountLink"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        ActionDataTablePanel table = new ActionDataTablePanel("resourceDatatable", columns, (ISortableDataProvider)new StatusBeanProvider(this), 10, pageRef);
        String pageId = "Resources";
        table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.UNLINK, "Resources");
        table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.DEPROVISION, "Resources");
        table.addAction((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.UNASSIGN, "Resources");
        table.addCancelButton(window);
        this.add(new Component[]{table});
    }

    private void bulkAssociationAction(AjaxRequestTarget target, ResourceDeassociationActionType type, ActionDataTablePanel<StatusBean, String> table, List<IColumn<StatusBean, String>> columns) {
        ArrayList beans = new ArrayList(table.getModelObject());
        ArrayList<AbstractWrappable> subjectIds = new ArrayList<AbstractWrappable>();
        for (StatusBean bean : beans) {
            LOG.debug("Selected bean {}", (Object)bean);
            subjectIds.add(AbstractWrappable.getInstance(SubjectId.class, (Object)bean.getAttributableId()));
        }
        if (beans.isEmpty()) {
            this.window.close(target);
        } else {
            BulkActionResult res = this.resourceRestClient.bulkAssociationAction(this.resourceTO.getName(), this.typeRef, type, subjectIds);
            ((BasePage)this.pageRef.getPage()).setModalResult(true);
            this.setResponsePage((Page)new BulkActionResultModalPage(this.window, beans, columns, res, "attributableId"));
        }
    }

    static /* synthetic */ StatusUtils access$000(ProvisioningModalPage x0) {
        return x0.statusUtils;
    }

    static /* synthetic */ void access$100(ProvisioningModalPage x0, AjaxRequestTarget x1, ResourceDeassociationActionType x2, ActionDataTablePanel x3, List x4) {
        x0.bulkAssociationAction(x1, x2, x3, x4);
    }

    static /* synthetic */ ResourceTO access$200(ProvisioningModalPage x0) {
        return x0.resourceTO;
    }

    static /* synthetic */ Class access$300(ProvisioningModalPage x0) {
        return x0.typeRef;
    }
}

