/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.services.EntitlementService;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.pages.Login;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.rest.UserSelfRestClient;
import org.apache.syncope.console.wicket.markup.html.form.LinkPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Login
extends WebPage {
    private static final long serialVersionUID = -3744389270366566218L;
    private static final int SELF_REG_WIN_HEIGHT = 550;
    private static final int SELF_REG_WIN_WIDTH = 800;
    private static final int PWD_RESET_WIN_HEIGHT = 300;
    private static final int PWD_RESET_WIN_WIDTH = 800;
    @SpringBean(name="version")
    private String version;
    @SpringBean(name="anonymousUser")
    private String anonymousUser;
    @SpringBean(name="anonymousKey")
    private String anonymousKey;
    @SpringBean
    private UserSelfRestClient userSelfRestClient;
    private final StatelessForm<Void> form;
    private final TextField<String> userIdField;
    private final TextField<String> passwordField;
    private final DropDownChoice<Locale> languageSelect;
    private final NotificationPanel feedbackPanel;

    public Login(PageParameters parameters) {
        super(parameters);
        Fragment pwdResetFrag;
        Fragment selfRegFrag;
        this.setStatelessHint(true);
        this.feedbackPanel = new NotificationPanel("feedback");
        this.add(new Component[]{this.feedbackPanel});
        this.form = new StatelessForm("login");
        this.userIdField = new TextField("userId", (IModel)new Model());
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown(this, "language");
        this.form.add(new Component[]{this.languageSelect});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        ModalWindow selfRegModalWin = new ModalWindow("selfRegModal");
        selfRegModalWin.setCssClassName("w_silver");
        selfRegModalWin.setInitialHeight(550);
        selfRegModalWin.setInitialWidth(800);
        selfRegModalWin.setCookieName("self-reg-modal");
        this.add(new Component[]{selfRegModalWin});
        if (this.userSelfRestClient.isSelfRegistrationAllowed()) {
            selfRegFrag = new Fragment("selfRegistration", "selfRegAllowed", (MarkupContainer)this);
            2 selfRegLink = new /* Unavailable Anonymous Inner Class!! */;
            selfRegLink.add(new Component[]{new Label("linkTitle", this.getString("selfRegistration"))});
            LinkPanel panel = new LinkPanel("selfRegistration", (IModel)new ResourceModel("selfRegistration"));
            panel.add(new Component[]{selfRegLink});
            selfRegFrag.add(new Component[]{panel});
        } else {
            selfRegFrag = new Fragment("selfRegistration", "selfRegNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{selfRegFrag});
        ModalWindow pwdResetReqModalWin = new ModalWindow("pwdResetReqModal");
        pwdResetReqModalWin.setCssClassName("w_silver");
        pwdResetReqModalWin.setInitialHeight(300);
        pwdResetReqModalWin.setInitialWidth(800);
        pwdResetReqModalWin.setCookieName("pwd-reset-req-modal");
        this.add(new Component[]{pwdResetReqModalWin});
        if (this.userSelfRestClient.isPasswordResetAllowed()) {
            pwdResetFrag = new Fragment("passwordReset", "pwdResetAllowed", (MarkupContainer)this);
            3 pwdResetLink = new /* Unavailable Anonymous Inner Class!! */;
            pwdResetLink.add(new Component[]{new Label("linkTitle", this.getString("passwordReset"))});
            LinkPanel panel = new LinkPanel("passwordReset", (IModel)new ResourceModel("passwordReset"));
            panel.add(new Component[]{pwdResetLink});
            pwdResetFrag.add(new Component[]{panel});
        } else {
            pwdResetFrag = new Fragment("passwordReset", "pwdResetNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{pwdResetFrag});
        String pwdResetToken = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("pwdResetToken").toOptionalString();
        ModalWindow pwdResetConfModalWin = new ModalWindow("pwdResetConfModal");
        if (StringUtils.isNotBlank((CharSequence)pwdResetToken)) {
            pwdResetConfModalWin.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        }
        pwdResetConfModalWin.setCssClassName("w_silver");
        pwdResetConfModalWin.setInitialHeight(300);
        pwdResetConfModalWin.setInitialWidth(800);
        pwdResetConfModalWin.setCookieName("pwd-reset-conf-modal");
        pwdResetConfModalWin.setPageCreator((ModalWindow.PageCreator)new /* Unavailable Anonymous Inner Class!! */);
        pwdResetConfModalWin.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{pwdResetConfModalWin});
    }

    private void authenticate(String username, String password) {
        List entitlements = ((EntitlementService)SyncopeSession.get().getService(EntitlementService.class, username, password)).getOwnEntitlements();
        SyncopeSession.get().setUsername(username);
        SyncopeSession.get().setPassword(password);
        SyncopeSession.get().setEntitlements(CollectionWrapper.unwrap((Collection)entitlements).toArray(new String[0]));
        SyncopeSession.get().setVersion(this.version);
    }

    static /* synthetic */ TextField access$000(Login x0) {
        return x0.userIdField;
    }

    static /* synthetic */ String access$100(Login x0) {
        return x0.anonymousUser;
    }

    static /* synthetic */ TextField access$200(Login x0) {
        return x0.passwordField;
    }

    static /* synthetic */ void access$300(Login x0, String x1, String x2) {
        x0.authenticate(x1, x2);
    }

    static /* synthetic */ NotificationPanel access$400(Login x0) {
        return x0.feedbackPanel;
    }

    static /* synthetic */ String access$500(Login x0) {
        return x0.anonymousKey;
    }
}

