/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.ConnPoolConfTO;
import org.apache.syncope.common.types.ConnConfPropSchema;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.types.ConnectorCapability;
import org.apache.syncope.console.markup.html.list.ConnConfPropertyListView;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ConnectorModalPage;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;

public class ConnectorModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -2025535531121434050L;
    @SpringBean
    private ConnectorRestClient restClient;
    private final Map<String, Map<String, Map<String, ConnBundleTO>>> mapConnBundleTOs;
    private final List<ConnectorCapability> selectedCapabilities;
    private ConnBundleTO bundleTO;
    private List<ConnConfProperty> properties;
    private final WebMarkupContainer propertiesContainer;

    public ConnectorModalPage(PageReference pageRef, ModalWindow window, ConnInstanceTO connInstanceTO) {
        this.selectedCapabilities = new ArrayList<ConnectorCapability>(connInstanceTO.getId() == 0L ? EnumSet.noneOf(ConnectorCapability.class) : connInstanceTO.getCapabilities());
        this.mapConnBundleTOs = new HashMap();
        for (ConnBundleTO connBundleTO : this.restClient.getAllBundles()) {
            Map byName;
            Map byLocation;
            if (!this.mapConnBundleTOs.containsKey(connBundleTO.getLocation())) {
                this.mapConnBundleTOs.put(connBundleTO.getLocation(), new HashMap());
            }
            if (!(byLocation = (Map)this.mapConnBundleTOs.get(connBundleTO.getLocation())).containsKey(connBundleTO.getBundleName())) {
                byLocation.put(connBundleTO.getBundleName(), new HashMap());
            }
            if ((byName = (Map)byLocation.get(connBundleTO.getBundleName())).containsKey(connBundleTO.getVersion())) continue;
            byName.put(connBundleTO.getVersion(), connBundleTO);
        }
        this.bundleTO = this.getSelectedBundleTO(connInstanceTO);
        this.properties = this.fillProperties(this.bundleTO, connInstanceTO);
        Form connectorForm = new Form("form");
        connectorForm.setModel((IModel)new CompoundPropertyModel((Object)connInstanceTO));
        connectorForm.setOutputMarkupId(true);
        this.add(new Component[]{connectorForm});
        this.propertiesContainer = new WebMarkupContainer("container");
        this.propertiesContainer.setOutputMarkupId(true);
        connectorForm.add(new Component[]{this.propertiesContainer});
        Form connectorPropForm = new Form("connectorPropForm");
        connectorPropForm.setModel((IModel)new CompoundPropertyModel((Object)connInstanceTO));
        connectorPropForm.setOutputMarkupId(true);
        this.propertiesContainer.add(new Component[]{connectorPropForm});
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "display name", (IModel)new PropertyModel((Object)connInstanceTO, "displayName"));
        displayName.setOutputMarkupId(true);
        displayName.addRequiredLabel();
        connectorForm.add(new Component[]{displayName});
        AjaxDropDownChoicePanel location = new AjaxDropDownChoicePanel("location", "location", (IModel)new Model(this.bundleTO == null ? null : this.bundleTO.getLocation()));
        ((DropDownChoice)location.getField()).setNullValid(true);
        location.setStyleSheet("long_dynamicsize");
        location.setChoices(new ArrayList(this.mapConnBundleTOs.keySet()));
        location.setRequired(true);
        location.addRequiredLabel();
        location.setOutputMarkupId(true);
        location.setEnabled(connInstanceTO.getId() == 0L);
        location.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{location});
        AjaxDropDownChoicePanel connectorName = new AjaxDropDownChoicePanel("connectorName", "connectorName", (IModel)new Model(this.bundleTO == null ? null : this.bundleTO.getBundleName()));
        ((DropDownChoice)connectorName.getField()).setNullValid(true);
        connectorName.setStyleSheet("long_dynamicsize");
        connectorName.setChoices(this.bundleTO == null ? new ArrayList() : new ArrayList(((Map)this.mapConnBundleTOs.get(connInstanceTO.getLocation())).keySet()));
        connectorName.setRequired(true);
        connectorName.addRequiredLabel();
        connectorName.setEnabled(connInstanceTO.getLocation() != null);
        connectorName.setOutputMarkupId(true);
        connectorName.setEnabled(connInstanceTO.getId() == 0L);
        connectorName.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{connectorName});
        AjaxDropDownChoicePanel version = new AjaxDropDownChoicePanel("version", "version", (IModel)new Model(this.bundleTO == null ? null : this.bundleTO.getVersion()));
        version.setStyleSheet("long_dynamicsize");
        version.setChoices(this.bundleTO == null ? new ArrayList() : new ArrayList(((Map)((Map)this.mapConnBundleTOs.get(connInstanceTO.getLocation())).get(connInstanceTO.getBundleName())).keySet()));
        version.setRequired(true);
        version.addRequiredLabel();
        version.setEnabled(connInstanceTO.getBundleName() != null);
        version.setOutputMarkupId(true);
        version.addRequiredLabel();
        version.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{version});
        SpinnerFieldPanel connRequestTimeout = new SpinnerFieldPanel("connRequestTimeout", "connRequestTimeout", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO, "connRequestTimeout"), (Number)0, null);
        connRequestTimeout.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{connRequestTimeout});
        if (connInstanceTO.getPoolConf() == null) {
            connInstanceTO.setPoolConf(new ConnPoolConfTO());
        }
        SpinnerFieldPanel poolMaxObjects = new SpinnerFieldPanel("poolMaxObjects", "poolMaxObjects", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxObjects"), (Number)0, null);
        poolMaxObjects.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxObjects});
        SpinnerFieldPanel poolMinIdle = new SpinnerFieldPanel("poolMinIdle", "poolMinIdle", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minIdle"), (Number)0, null);
        poolMinIdle.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMinIdle});
        SpinnerFieldPanel poolMaxIdle = new SpinnerFieldPanel("poolMaxIdle", "poolMaxIdle", Integer.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxIdle"), (Number)0, null);
        poolMaxIdle.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxIdle});
        SpinnerFieldPanel poolMaxWait = new SpinnerFieldPanel("poolMaxWait", "poolMaxWait", Long.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxWait"), (Number)0L, null);
        poolMaxWait.getField().add((IValidator)new RangeValidator((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxWait});
        SpinnerFieldPanel poolMinEvictableIdleTime = new SpinnerFieldPanel("poolMinEvictableIdleTime", "poolMinEvictableIdleTime", Long.class, (IModel)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minEvictableIdleTimeMillis"), (Number)0L, null);
        poolMinEvictableIdleTime.getField().add((IValidator)new RangeValidator((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMinEvictableIdleTime});
        location.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        connectorName.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        version.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        ConnConfPropertyListView connPropView = new ConnConfPropertyListView("connectorProperties", (IModel)new PropertyModel((Object)this, "properties"), true, connInstanceTO.getConfiguration());
        connPropView.setOutputMarkupId(true);
        connectorPropForm.add(new Component[]{connPropView});
        4 check = new /* Unavailable Anonymous Inner Class!! */;
        connectorPropForm.add(new Component[]{check});
        5 capabilities = new /* Unavailable Anonymous Inner Class!! */;
        CheckBoxMultipleChoice capabilitiesPalette = new CheckBoxMultipleChoice("capabilitiesPalette", (IModel)new PropertyModel((Object)this, "selectedCapabilities"), (IModel)capabilities);
        capabilitiesPalette.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        connectorForm.add(new Component[]{capabilitiesPalette});
        7 submit = new /* Unavailable Anonymous Inner Class!! */;
        String roles = connInstanceTO.getId() == 0L ? this.xmlRolesReader.getEntitlement("Connectors", "create") : this.xmlRolesReader.getEntitlement("Connectors", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)roles);
        connectorForm.add(new Component[]{submit});
        8 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        connectorForm.add(new Component[]{cancel});
    }

    private ConnBundleTO getSelectedBundleTO(ConnInstanceTO connInstanceTO) {
        Map byName;
        Map byLocation;
        ConnBundleTO result = null;
        if (connInstanceTO != null && StringUtils.isNotBlank((CharSequence)connInstanceTO.getLocation()) && StringUtils.isNotBlank((CharSequence)connInstanceTO.getBundleName()) && StringUtils.isNotBlank((CharSequence)connInstanceTO.getVersion()) && this.mapConnBundleTOs.containsKey(connInstanceTO.getLocation()) && (byLocation = (Map)this.mapConnBundleTOs.get(connInstanceTO.getLocation())).containsKey(connInstanceTO.getBundleName()) && (byName = (Map)byLocation.get(connInstanceTO.getBundleName())).containsKey(connInstanceTO.getVersion())) {
            result = (ConnBundleTO)byName.get(connInstanceTO.getVersion());
        }
        return result;
    }

    private List<ConnConfProperty> fillProperties(ConnBundleTO bundleTO, ConnInstanceTO connInstanceTO) {
        ArrayList<ConnConfProperty> props = new ArrayList<ConnConfProperty>();
        if (bundleTO != null) {
            for (ConnConfPropSchema key : bundleTO.getProperties()) {
                ConnConfProperty property = new ConnConfProperty();
                property.setSchema(key);
                if (connInstanceTO.getId() != 0L && connInstanceTO.getConfigurationMap().containsKey(key.getName()) && ((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).getValues() != null) {
                    property.getValues().addAll(((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).getValues());
                    property.setOverridable(((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).isOverridable());
                }
                if (property.getValues().isEmpty() && !key.getDefaultValues().isEmpty()) {
                    property.getValues().addAll(key.getDefaultValues());
                }
                props.add(property);
            }
        }
        Collections.sort(props);
        return props;
    }

    private void selectVersion(AjaxRequestTarget target, ConnInstanceTO connInstanceTO, AjaxDropDownChoicePanel<String> version, String versionValue) {
        connInstanceTO.setVersion(versionValue);
        target.add(new Component[]{version});
        this.bundleTO = this.getSelectedBundleTO(connInstanceTO);
        this.properties = this.fillProperties(this.bundleTO, connInstanceTO);
        target.add(new Component[]{this.propertiesContainer});
    }

    public List<ConnConfProperty> getProperties() {
        return this.properties;
    }

    static /* synthetic */ Map access$000(ConnectorModalPage x0) {
        return x0.mapConnBundleTOs;
    }

    static /* synthetic */ List access$100(ConnectorModalPage x0) {
        return x0.properties;
    }

    static /* synthetic */ WebMarkupContainer access$200(ConnectorModalPage x0) {
        return x0.propertiesContainer;
    }

    static /* synthetic */ void access$300(ConnectorModalPage x0, AjaxRequestTarget x1, ConnInstanceTO x2, AjaxDropDownChoicePanel x3, String x4) {
        x0.selectVersion(x1, x2, x3, x4);
    }

    static /* synthetic */ ConnBundleTO access$400(ConnectorModalPage x0) {
        return x0.bundleTO;
    }

    static /* synthetic */ ConnectorRestClient access$500(ConnectorModalPage x0) {
        return x0.restClient;
    }

    static /* synthetic */ List access$600(ConnectorModalPage x0) {
        return x0.selectedCapabilities;
    }
}

