/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.panels.ImagePanel;
import org.apache.syncope.console.pages.panels.StatusPanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatusUtils
implements Serializable {
    private static final long serialVersionUID = 7238009174387184309L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusUtils.class);
    public static final String IMG_STATUES = "../statuses/";
    private final AbstractSubjectRestClient restClient;

    public StatusUtils(AbstractSubjectRestClient restClient) {
        this.restClient = restClient;
    }

    public List<ConnObjectWrapper> getConnectorObjects(AbstractSubjectTO subject) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        objects.addAll(this.getConnectorObjects(subject, (Collection)subject.getResources()));
        return objects;
    }

    public List<ConnObjectWrapper> getConnectorObjects(Collection<AbstractSubjectTO> subjects, Collection<String> resources) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        for (AbstractSubjectTO subject : subjects) {
            objects.addAll(this.getConnectorObjects(subject, resources));
        }
        return objects;
    }

    private List<ConnObjectWrapper> getConnectorObjects(AbstractSubjectTO subject, Collection<String> resources) {
        ArrayList<ConnObjectWrapper> objects = new ArrayList<ConnObjectWrapper>();
        for (String resourceName : resources) {
            ConnObjectTO objectTO = null;
            try {
                objectTO = this.restClient.getConnectorObject(resourceName, Long.valueOf(subject.getId()));
            }
            catch (Exception e) {
                LOG.warn("ConnObject '{}' not found on resource '{}'", (Object)subject.getId(), (Object)resourceName);
            }
            objects.add(new ConnObjectWrapper((AbstractAttributableTO)subject, resourceName, objectTO));
        }
        return objects;
    }

    public StatusBean getStatusBean(AbstractAttributableTO attributable, String resourceName, ConnObjectTO objectTO, boolean isRole) {
        StatusBean statusBean = new StatusBean(attributable, resourceName);
        if (objectTO != null) {
            Boolean enabled = this.isEnabled(objectTO);
            Status status = enabled == null ? (isRole ? Status.ACTIVE : Status.UNDEFINED) : (enabled != false ? Status.ACTIVE : Status.SUSPENDED);
            String accountLink = this.getAccountLink(objectTO);
            statusBean.setStatus(status);
            statusBean.setAccountLink(accountLink);
        }
        return statusBean;
    }

    private Boolean isEnabled(ConnObjectTO objectTO) {
        Map attributeTOs = objectTO.getAttrMap();
        AttributeTO status = (AttributeTO)attributeTOs.get("__ENABLE__");
        return status != null && status.getValues() != null && !status.getValues().isEmpty() ? Boolean.valueOf(Boolean.parseBoolean((String)status.getValues().get(0))) : null;
    }

    private String getAccountLink(ConnObjectTO objectTO) {
        Map attributeTOs = objectTO == null ? Collections.emptyMap() : objectTO.getAttrMap();
        AttributeTO name = (AttributeTO)attributeTOs.get("__NAME__");
        return name != null && name.getValues() != null && !name.getValues().isEmpty() ? (String)name.getValues().get(0) : null;
    }

    public static StatusMod buildStatusMod(Collection<StatusBean> statuses) {
        return StatusUtils.buildStatusMod(statuses, null);
    }

    public static StatusMod buildStatusMod(Collection<StatusBean> statuses, Boolean enable) {
        StatusMod statusMod = new StatusMod();
        statusMod.setOnSyncope(false);
        for (StatusBean status : statuses) {
            if (enable != null && (!enable.booleanValue() || status.getStatus().isActive()) && (enable.booleanValue() || !status.getStatus().isActive())) continue;
            if ("syncope".equalsIgnoreCase(status.getResourceName())) {
                statusMod.setOnSyncope(true);
                continue;
            }
            statusMod.getResourceNames().add(status.getResourceName());
        }
        return statusMod;
    }

    public static void update(AbstractAttributableTO attributable, StatusPanel statusPanel, AjaxRequestTarget target, Collection<String> resourcesToAdd, Collection<String> resourcesToRemove) {
        if (statusPanel != null) {
            LinkedHashMap<String, StatusBean> statusMap = new LinkedHashMap<String, StatusBean>();
            for (StatusBean statusBean : statusPanel.getStatusBeans()) {
                statusMap.put(statusBean.getResourceName(), statusBean);
            }
            for (String resourceName : resourcesToAdd) {
                StatusBean statusBean;
                if (statusMap.keySet().contains(resourceName)) continue;
                if (statusPanel.getInitialStatusBeanMap().containsKey(resourceName)) {
                    statusBean = (StatusBean)statusPanel.getInitialStatusBeanMap().get(resourceName);
                } else {
                    statusBean = new StatusBean(attributable, resourceName);
                    statusBean.setStatus(Status.NOT_YET_SUBMITTED);
                }
                statusMap.put(statusBean.getResourceName(), statusBean);
            }
            for (String resource : resourcesToRemove) {
                statusMap.remove(resource);
            }
            statusPanel.updateStatusBeans(new ArrayList(statusMap.values()));
            target.add(new Component[]{statusPanel});
        }
    }

    public ConnObjectTO getConnObjectTO(Long attributableId, String resourceName, List<ConnObjectWrapper> objects) {
        for (ConnObjectWrapper object : objects) {
            if (!attributableId.equals(object.getAttributable().getId()) || !resourceName.equalsIgnoreCase(object.getResourceName())) continue;
            return object.getConnObjectTO();
        }
        return null;
    }

    public Image getStatusImage(String componentId, Status status) {
        String title;
        String alt;
        String statusName;
        switch (3.$SwitchMap$org$apache$syncope$console$commons$status$Status[status.ordinal()]) {
            case 1: {
                statusName = Status.UNDEFINED.toString();
                alt = "undefined icon";
                title = "Not yet submitted";
                break;
            }
            case 2: {
                statusName = Status.ACTIVE.toString();
                alt = "active icon";
                title = "Enabled";
                break;
            }
            case 3: {
                statusName = Status.UNDEFINED.toString();
                alt = "undefined icon";
                title = "Undefined status";
                break;
            }
            case 4: {
                statusName = Status.OBJECT_NOT_FOUND.toString();
                alt = "notfound icon";
                title = "Not found";
                break;
            }
            default: {
                statusName = Status.SUSPENDED.toString();
                alt = "inactive icon";
                title = "Disabled";
            }
        }
        Image img = new Image(componentId, "../statuses/" + statusName + ".png");
        img.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        return img;
    }

    public ImagePanel getStatusImagePanel(String componentId, Status status) {
        String title;
        String alt;
        String statusName;
        switch (3.$SwitchMap$org$apache$syncope$console$commons$status$Status[status.ordinal()]) {
            case 1: {
                statusName = Status.UNDEFINED.toString();
                alt = "undefined icon";
                title = "Not yet submitted";
                break;
            }
            case 2: {
                statusName = Status.ACTIVE.toString();
                alt = "active icon";
                title = "Enabled";
                break;
            }
            case 3: {
                statusName = Status.UNDEFINED.toString();
                alt = "undefined icon";
                title = "Undefined status";
                break;
            }
            case 4: {
                statusName = Status.OBJECT_NOT_FOUND.toString();
                alt = "notfound icon";
                title = "Not found";
                break;
            }
            default: {
                statusName = Status.SUSPENDED.toString();
                alt = "inactive icon";
                title = "Disabled";
            }
        }
        ImagePanel imagePanel = new ImagePanel(componentId, "../statuses/" + statusName + ".png");
        imagePanel.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        return imagePanel;
    }
}

