/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class HttpResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 5811207817876330189L;
    private transient InputStream inputStream;
    private String contentType;
    private String location;
    private String filename;

    public HttpResourceStream(Response response) {
        Object entity = response.getEntity();
        if (response.getStatusInfo().getStatusCode() == Response.Status.OK.getStatusCode() && entity instanceof InputStream) {
            String[] splitted;
            this.inputStream = (InputStream)entity;
            this.contentType = response.getHeaderString("Content-Type");
            this.location = response.getLocation() == null ? null : response.getLocation().toASCIIString();
            String contentDisposition = response.getHeaderString("Content-Disposition");
            if (StringUtils.isNotBlank((CharSequence)contentDisposition) && (splitted = contentDisposition.split("=")) != null && splitted.length > 1) {
                this.filename = splitted[1].trim();
            }
        }
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.inputStream == null ? new ByteArrayInputStream(new byte[0]) : this.inputStream;
    }

    public Bytes length() {
        return this.inputStream == null ? Bytes.bytes((long)0L) : null;
    }

    public void close() throws IOException {
    }

    public String locationAsString() {
        return this.location;
    }

    public String getContentType() {
        return this.contentType == null ? "application/octet-stream" : this.contentType;
    }

    public String getFilename() {
        return this.filename;
    }
}

