/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.console.commons.SortableAttributableProviderComparator;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributableDataProvider
extends SortableDataProvider<AbstractAttributableTO, String> {
    private static final long serialVersionUID = 6267494272884913376L;
    private static final Logger LOG = LoggerFactory.getLogger(AttributableDataProvider.class);
    private final SortableAttributableProviderComparator comparator;
    private String fiql = null;
    private final int paginatorRows;
    private final boolean filtered;
    private final AbstractSubjectRestClient restClient;

    public AttributableDataProvider(AbstractSubjectRestClient restClient, int paginatorRows, boolean filtered) {
        this.restClient = restClient;
        this.filtered = filtered;
        this.paginatorRows = paginatorRows;
        this.setSort((Object)"id", SortOrder.ASCENDING);
        this.comparator = new SortableAttributableProviderComparator((SortableDataProvider)this);
    }

    public void setFIQL(String fiql) {
        this.fiql = fiql;
    }

    public Iterator<? extends AbstractAttributableTO> iterator(long first, long count) {
        int page = (int)first / this.paginatorRows;
        List result = this.filtered ? (this.fiql == null ? Collections.emptyList() : this.restClient.search(this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, this.getSort())) : this.restClient.list((page < 0 ? 0 : page) + 1, this.paginatorRows, this.getSort());
        Collections.sort(result, this.comparator);
        return result.iterator();
    }

    public long size() {
        long result = this.filtered ? (this.fiql == null ? 0L : (long)this.restClient.searchCount(this.fiql)) : (long)this.restClient.count();
        return result;
    }

    public IModel<AbstractAttributableTO> model(AbstractAttributableTO object) {
        return new CompoundPropertyModel((Object)object);
    }
}

