/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientCompositeException;
import org.apache.syncope.common.types.ClientExceptionType;

public class SyncopeClientException
extends RuntimeException {
    private static final long serialVersionUID = 3380920886511913475L;
    private ClientExceptionType type;
    private final List<String> elements = new ArrayList<String>();

    public static SyncopeClientException build(ClientExceptionType type) {
        if (type == ClientExceptionType.Composite) {
            throw new IllegalArgumentException("Composite exceptions must be obtained via buildComposite()");
        }
        return new SyncopeClientException(type);
    }

    public static SyncopeClientCompositeException buildComposite() {
        return new SyncopeClientCompositeException();
    }

    protected SyncopeClientException(ClientExceptionType type) {
        this.setType(type);
    }

    public boolean isComposite() {
        return this.getType() == ClientExceptionType.Composite;
    }

    public SyncopeClientCompositeException asComposite() {
        if (!this.isComposite()) {
            throw new IllegalArgumentException("This is not a composite exception");
        }
        return (SyncopeClientCompositeException)this;
    }

    public ClientExceptionType getType() {
        return this.type;
    }

    public final void setType(ClientExceptionType type) {
        this.type = type;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append((Object)this.getType());
        message.append(" ");
        message.append(this.getElements());
        return message.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

