/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;

public class LoggerEventUtils {
    public static Map.Entry<EventCategoryTO, AuditElements.Result> parseEventCategory(String event) {
        EventCategoryTO eventCategoryTO = new EventCategoryTO();
        AuditElements.Result condition = null;
        if (StringUtils.isNotEmpty((CharSequence)event)) {
            String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
            if (elements.length == 1) {
                eventCategoryTO.setType(AuditElements.EventCategoryType.CUSTOM);
                condition = AuditElements.Result.SUCCESS;
                eventCategoryTO.getEvents().add(event);
            } else {
                AuditElements.EventCategoryType type;
                if (AuditElements.EventCategoryType.PROPAGATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PROPAGATION;
                } else if (AuditElements.EventCategoryType.SYNCHRONIZATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.SYNCHRONIZATION;
                } else if (AuditElements.EventCategoryType.PUSH.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PUSH;
                } else {
                    try {
                        type = AuditElements.EventCategoryType.valueOf(elements[0]);
                    }
                    catch (Exception e) {
                        type = AuditElements.EventCategoryType.CUSTOM;
                    }
                }
                eventCategoryTO.setType(type);
                eventCategoryTO.setCategory(StringUtils.isNotEmpty((CharSequence)elements[1]) ? elements[1] : null);
                eventCategoryTO.setSubcategory(StringUtils.isNotEmpty((CharSequence)elements[2]) ? elements[2] : null);
                if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                    eventCategoryTO.getEvents().add(elements[3]);
                }
                if (elements.length > 4) {
                    condition = AuditElements.Result.valueOf(elements[4].toUpperCase());
                }
            }
        }
        return new AbstractMap.SimpleEntry<EventCategoryTO, Object>(eventCategoryTO, condition);
    }

    public static String buildEvent(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result resultValueCondition) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            if (StringUtils.isNotBlank((CharSequence)type.toString())) {
                eventBuilder.append(type.toString());
            } else {
                eventBuilder.append(type.name());
            }
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append(']');
        eventBuilder.append(":");
        eventBuilder.append('[');
        if (StringUtils.isNotBlank((CharSequence)event)) {
            eventBuilder.append(event);
        }
        eventBuilder.append(']');
        if (resultValueCondition != null) {
            eventBuilder.append(":");
            eventBuilder.append('[');
            eventBuilder.append((Object)resultValueCondition);
            eventBuilder.append(']');
        }
        return eventBuilder.toString();
    }
}

