/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.types;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import org.apache.syncope.common.types.AttributableType;

@XmlEnum
public enum IntMappingType {
    UserSchema(AttributableType.USER),
    UserDerivedSchema(AttributableType.USER),
    UserVirtualSchema(AttributableType.USER),
    UserId(AttributableType.USER),
    Username(AttributableType.USER),
    Password(AttributableType.USER),
    RoleSchema(AttributableType.ROLE),
    RoleDerivedSchema(AttributableType.ROLE),
    RoleVirtualSchema(AttributableType.ROLE),
    RoleId(AttributableType.ROLE),
    RoleName(AttributableType.ROLE),
    RoleOwnerSchema(AttributableType.ROLE),
    MembershipSchema(AttributableType.MEMBERSHIP),
    MembershipDerivedSchema(AttributableType.MEMBERSHIP),
    MembershipVirtualSchema(AttributableType.MEMBERSHIP),
    MembershipId(AttributableType.MEMBERSHIP);

    private AttributableType attributableType;

    private IntMappingType(AttributableType attributableType) {
        this.attributableType = attributableType;
    }

    public AttributableType getAttributableType() {
        return this.attributableType;
    }

    public static Set<IntMappingType> getAttributeTypes(AttributableType attributableType, Collection<IntMappingType> toBeFiltered) {
        Set<IntMappingType> res = IntMappingType.getAttributeTypes(attributableType);
        res.removeAll(toBeFiltered);
        return res;
    }

    public static Set<IntMappingType> getAttributeTypes(AttributableType attributableType) {
        EnumSet<Enum> enumset;
        switch (attributableType) {
            case ROLE: {
                enumset = EnumSet.allOf(RoleMappingType.class);
                break;
            }
            case MEMBERSHIP: {
                enumset = EnumSet.allOf(MembershipMappingType.class);
                break;
            }
            default: {
                enumset = EnumSet.allOf(UserMappingType.class);
            }
        }
        HashSet<IntMappingType> result = new HashSet<IntMappingType>(enumset.size());
        for (Object e : enumset) {
            result.add(IntMappingType.valueOf(e.toString()));
        }
        return result;
    }

    public static Set<IntMappingType> getEmbedded() {
        return EnumSet.of(UserId, new IntMappingType[]{Username, Password, RoleId, RoleName, RoleOwnerSchema, MembershipId});
    }

    public static boolean contains(AttributableType attributableType, String type) {
        switch (attributableType) {
            case ROLE: {
                for (RoleMappingType c : RoleMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
                break;
            }
            case MEMBERSHIP: {
                for (MembershipMappingType c : MembershipMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
                break;
            }
            default: {
                for (UserMappingType c : UserMappingType.values()) {
                    if (!c.name().equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static enum MembershipMappingType {
        MembershipSchema,
        MembershipDerivedSchema,
        MembershipVirtualSchema,
        MembershipId;

    }

    private static enum RoleMappingType {
        RoleSchema,
        RoleDerivedSchema,
        RoleVirtualSchema,
        RoleId,
        RoleName,
        RoleOwnerSchema;

    }

    private static enum UserMappingType {
        UserSchema,
        UserDerivedSchema,
        UserVirtualSchema,
        UserId,
        Username,
        Password;

    }
}

