/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConnObjectTO;

@XmlType
public abstract class AbstractAttributableTO
extends ConnObjectTO {
    private static final long serialVersionUID = 4083884098736820255L;
    private long id;
    private final List<AttributeTO> derAttrs = new ArrayList<AttributeTO>();
    private final List<AttributeTO> virAttrs = new ArrayList<AttributeTO>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @JsonIgnore
    public Map<String, AttributeTO> getDerAttrMap() {
        HashMap<String, AttributeTO> result = new HashMap(this.derAttrs.size());
        for (AttributeTO attributeTO : this.derAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @JsonIgnore
    public Map<String, AttributeTO> getVirAttrMap() {
        HashMap<String, AttributeTO> result = new HashMap(this.virAttrs.size());
        for (AttributeTO attributeTO : this.virAttrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @XmlElementWrapper(name="derivedAttributes")
    @XmlElement(name="attribute")
    @JsonProperty(value="derivedAttributes")
    public List<AttributeTO> getDerAttrs() {
        return this.derAttrs;
    }

    @XmlElementWrapper(name="virtualAttributes")
    @XmlElement(name="attribute")
    @JsonProperty(value="virtualAttributes")
    public List<AttributeTO> getVirAttrs() {
        return this.virAttrs;
    }
}

