/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.types.SubjectType;
import org.apache.syncope.common.wrap.PropagationActionClass;
import org.apache.syncope.common.wrap.SubjectId;

@Path(value="resources")
public interface ResourceService
extends JAXRSService {
    @GET
    @Path(value="{resourceName}/{type}/{id}")
    @Produces(value={"application/xml", "application/json"})
    public ConnObjectTO getConnectorObject(@NotNull @PathParam(value="resourceName") String var1, @NotNull @PathParam(value="type") SubjectType var2, @NotNull @PathParam(value="id") Long var3);

    @GET
    @Path(value="propagationActionsClasses")
    @Produces(value={"application/xml", "application/json"})
    public List<PropagationActionClass> getPropagationActionsClasses();

    @GET
    @Path(value="{resourceName}")
    @Produces(value={"application/xml", "application/json"})
    public ResourceTO read(@NotNull @PathParam(value="resourceName") String var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public List<ResourceTO> list();

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created resource")})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response create(@NotNull ResourceTO var1);

    @PUT
    @Path(value="{resourceName}")
    @Consumes(value={"application/xml", "application/json"})
    public void update(@NotNull @PathParam(value="resourceName") String var1, @NotNull ResourceTO var2);

    @DELETE
    @Path(value="{resourceName}")
    @Consumes(value={"application/xml", "application/json"})
    public void delete(@NotNull @PathParam(value="resourceName") String var1);

    @POST
    @Path(value="check")
    @Consumes(value={"application/xml", "application/json"})
    public boolean check(@NotNull ResourceTO var1);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>BulkActionResult</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{resourceName}/bulkDeassociation/{subjType}/{type}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulkDeassociation(@NotNull @PathParam(value="resourceName") String var1, @NotNull @PathParam(value="subjType") SubjectType var2, @NotNull @PathParam(value="type") ResourceDeassociationActionType var3, @NotNull List<SubjectId> var4);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

