/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.to.MappingItemTO;
import org.apache.syncope.common.types.IntMappingType;

@XmlRootElement(name="mapping")
@XmlType
public class MappingTO
extends AbstractBaseBean {
    private static final long serialVersionUID = 8447688036282611118L;
    private String accountLink;
    private final List<MappingItemTO> items = new ArrayList<MappingItemTO>();

    public String getAccountLink() {
        return this.accountLink;
    }

    public void setAccountLink(String accountLink) {
        this.accountLink = accountLink;
    }

    public <T extends MappingItemTO> T getAccountIdItem() {
        MappingItemTO accountIdItem = null;
        for (MappingItemTO item : this.getItems()) {
            if (!item.isAccountid()) continue;
            accountIdItem = item;
        }
        return (T)accountIdItem;
    }

    protected <T extends MappingItemTO> boolean addAccountIdItem(T accountIdItem) {
        if (IntMappingType.UserVirtualSchema == accountIdItem.getIntMappingType() || IntMappingType.RoleVirtualSchema == accountIdItem.getIntMappingType() || IntMappingType.MembershipVirtualSchema == accountIdItem.getIntMappingType() || IntMappingType.Password == accountIdItem.getIntMappingType()) {
            throw new IllegalArgumentException("Virtual attributes cannot be set as accountId");
        }
        if (IntMappingType.Password == accountIdItem.getIntMappingType()) {
            throw new IllegalArgumentException("Password attributes cannot be set as accountId");
        }
        accountIdItem.setExtAttrName(accountIdItem.getExtAttrName());
        accountIdItem.setAccountid(true);
        return this.addItem(accountIdItem);
    }

    public boolean setAccountIdItem(MappingItemTO accountIdItem) {
        if (accountIdItem == null) {
            return this.removeItem((MappingItemTO)this.getAccountIdItem());
        }
        return this.addAccountIdItem(accountIdItem);
    }

    public MappingItemTO getPasswordItem() {
        MappingItemTO passwordItem = null;
        for (MappingItemTO item : this.getItems()) {
            if (!item.isPassword()) continue;
            passwordItem = item;
        }
        return passwordItem;
    }

    public boolean setPasswordItem(MappingItemTO passwordItem) {
        if (passwordItem == null) {
            return this.removeItem(this.getPasswordItem());
        }
        passwordItem.setExtAttrName(null);
        passwordItem.setPassword(true);
        return this.addItem(passwordItem);
    }

    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<MappingItemTO> getItems() {
        return this.items;
    }

    public boolean addItem(MappingItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean removeItem(MappingItemTO item) {
        return this.items.remove(item);
    }
}

