/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.reqres.PagedResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.ReportExecExportFormat;
import org.apache.syncope.common.wrap.ReportletConfClass;

@Path(value="reports")
public interface ReportService
extends JAXRSService {
    @GET
    @Path(value="reportletConfClasses")
    @Produces(value={"application/xml", "application/json"})
    public List<ReportletConfClass> getReportletConfClasses();

    @GET
    @Path(value="{reportId}")
    @Produces(value={"application/xml", "application/json"})
    public ReportTO read(@NotNull @PathParam(value="reportId") Long var1);

    @GET
    @Path(value="executions/{executionId}")
    @Produces(value={"application/xml", "application/json"})
    public ReportExecTO readExecution(@NotNull @PathParam(value="executionId") Long var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<ReportTO> list();

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<ReportTO> list(@QueryParam(value="orderby") String var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<ReportTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<ReportTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2, @QueryParam(value="orderby") String var3);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created report")})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response create(@NotNull ReportTO var1);

    @PUT
    @Path(value="{reportId}")
    @Consumes(value={"application/xml", "application/json"})
    public void update(@NotNull @PathParam(value="reportId") Long var1, ReportTO var2);

    @DELETE
    @Path(value="{reportId}")
    public void delete(@NotNull @PathParam(value="reportId") Long var1);

    @DELETE
    @Path(value="executions/{executionId}")
    public void deleteExecution(@NotNull @PathParam(value="executionId") Long var1);

    @POST
    @Path(value="{reportId}/execute")
    @Produces(value={"application/xml", "application/json"})
    public ReportExecTO execute(@NotNull @PathParam(value="reportId") Long var1);

    @GET
    @Path(value="executions/{executionId}/stream")
    @Consumes(value={"application/xml", "application/json"})
    public Response exportExecutionResult(@NotNull @PathParam(value="executionId") Long var1, @QueryParam(value="format") ReportExecExportFormat var2);
}

