/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.buildtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.ldif.extractor.SchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;

public class JarSchemaLdifExtractor
implements SchemaLdifExtractor {
    private static final String SCHEMA_SUBDIR = "schema";
    private boolean extracted;
    private final File outputDirectory;
    private final File schemaDirectory;
    private final File jarFile;

    public JarSchemaLdifExtractor(File outputDirectory, File jarFile) throws IOException {
        this.outputDirectory = outputDirectory;
        this.schemaDirectory = new File(outputDirectory, SCHEMA_SUBDIR);
        this.jarFile = jarFile;
        if (!outputDirectory.exists() && !outputDirectory.mkdir()) {
            throw new IOException("Failed to create outputDirectory: " + outputDirectory);
        }
        this.extracted = !this.schemaDirectory.exists();
    }

    public boolean isExtracted() {
        return this.extracted;
    }

    public void extractOrCopy(boolean overwrite) throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdir()) {
            throw new IOException("Could not create " + this.outputDirectory.getAbsolutePath());
        }
        if (!this.schemaDirectory.exists()) {
            if (!this.schemaDirectory.mkdir()) {
                throw new IOException("Could not create " + this.schemaDirectory.getAbsolutePath());
            }
        } else if (!overwrite) {
            throw new IOException(I18n.err((String)"ERR_08001", (Object[])new Object[]{this.schemaDirectory.getAbsolutePath()}));
        }
        Pattern pattern = Pattern.compile(".*schema/ou=schema.*\\.ldif");
        for (String entry : this.getResources(pattern)) {
            this.extractFromJar(entry);
        }
    }

    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private Set<String> getResources(Pattern pattern) throws IOException {
        HashSet<String> result = new HashSet<String>();
        ZipFile zipFile = new ZipFile(this.jarFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!pattern.matcher(entry.getName()).matches()) continue;
            result.add(entry.getName());
        }
        zipFile.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromJar(String resource) throws IOException {
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream((String)resource, (String)"LDIF file in schema repository");
        try {
            File destination = new File(this.outputDirectory, resource);
            if (destination.exists()) {
                return;
            }
            if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                throw new IOException("Could not create " + destination.getParentFile().getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[512];
            try {
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

