/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.buildtools;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;
import org.identityconnectors.framework.server.ConnectorServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnIdStartStopListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConnIdStartStopListener.class);
    private static final String SERVER = "ConnIdConnectorServer";

    private List<URL> getBundleURLs(ServletContext ctx) {
        ArrayList<URL> bundleURLs = new ArrayList<URL>();
        for (String bundleFile : new String[]{"testconnectorserver.soap.bundle", "testconnectorserver.db.bundle", "testconnectorserver.csvdir.bundle", "testconnectorserver.ldap.bundle"}) {
            URL url = null;
            try {
                url = ctx.getResource("/WEB-INF/lib/" + ctx.getInitParameter(bundleFile));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url == null) continue;
            bundleURLs.add(url);
        }
        LOG.info("ConnId bundles loaded: " + bundleURLs);
        return bundleURLs;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ConnectorServer _server = ConnectorServer.newInstance();
        try {
            _server.setPort(Integer.parseInt(sce.getServletContext().getInitParameter("testconnectorserver.port")));
            _server.setBundleURLs(this.getBundleURLs(sce.getServletContext()));
            _server.setKeyHash(SecurityUtil.computeBase64SHA1Hash((char[])sce.getServletContext().getInitParameter("testconnectorserver.key").toCharArray()));
            _server.start();
            LOG.info("ConnId connector server listening on port " + _server.getPort());
        }
        catch (Exception e) {
            LOG.error("Could not start ConnId connector server", (Throwable)e);
        }
        sce.getServletContext().setAttribute(SERVER, (Object)_server);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ConnectorServer _server = (ConnectorServer)sce.getServletContext().getAttribute(SERVER);
        if (_server != null && _server.isStarted()) {
            _server.stop();
        }
        ThreadClassLoaderManager.clearInstance();
    }
}

