/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable;

import java.util.List;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.flowable.WorkflowFlowableProperties;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.flowable.impl.FlowableBpmnProcessManager;
import org.apache.syncope.core.flowable.impl.FlowableUserRequestHandler;
import org.apache.syncope.core.flowable.impl.FlowableUserWorkflowAdapter;
import org.apache.syncope.core.flowable.impl.FlowableWorkflowUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.flowable.support.DomainProcessEngineFactoryBean;
import org.apache.syncope.core.flowable.support.ShellServiceTaskDisablingBpmnParseHandler;
import org.apache.syncope.core.flowable.support.SyncopeEntitiesVariableType;
import org.apache.syncope.core.flowable.support.SyncopeFormHandlerHelper;
import org.apache.syncope.core.flowable.support.SyncopeIdmIdentityService;
import org.apache.syncope.core.flowable.task.AutoActivate;
import org.apache.syncope.core.flowable.task.Create;
import org.apache.syncope.core.flowable.task.Delete;
import org.apache.syncope.core.flowable.task.GenerateToken;
import org.apache.syncope.core.flowable.task.Notify;
import org.apache.syncope.core.flowable.task.PasswordReset;
import org.apache.syncope.core.flowable.task.Reactivate;
import org.apache.syncope.core.flowable.task.Suspend;
import org.apache.syncope.core.flowable.task.Update;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.flowable.engine.impl.form.FormHandlerHelper;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.idm.spring.configurator.SpringIdmEngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@EnableConfigurationProperties(value={WorkflowFlowableProperties.class})
@Configuration(proxyBeanMethods=false)
public class FlowableWorkflowContext {
    @ConditionalOnMissingBean
    @Bean
    public SpringIdmEngineConfiguration syncopeIdmEngineConfiguration(ConfigurableApplicationContext ctx) {
        SpringIdmEngineConfiguration conf = new SpringIdmEngineConfiguration();
        conf.setIdmIdentityService((IdmIdentityService)new SyncopeIdmIdentityService((IdmEngineConfiguration)conf, ctx));
        return conf;
    }

    @ConditionalOnMissingBean
    @Bean
    public SpringIdmEngineConfigurator syncopeIdmEngineConfigurator(SpringIdmEngineConfiguration syncopeIdmEngineConfiguration) {
        SpringIdmEngineConfigurator configurator = new SpringIdmEngineConfigurator();
        configurator.setIdmEngineConfiguration(syncopeIdmEngineConfiguration);
        return configurator;
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeFormHandlerHelper syncopeFormHandlerHelper() {
        return new SyncopeFormHandlerHelper();
    }

    @ConditionalOnMissingBean
    @Bean
    public FlowableBpmnProcessManager bpmnProcessManager(DomainProcessEngine engine) {
        return new FlowableBpmnProcessManager(engine);
    }

    @ConditionalOnMissingBean
    @Bean
    public FlowableUserRequestHandler userRequestHandler(SecurityProperties securityProperties, UserDataBinder userDataBinder, DomainProcessEngine engine, UserDAO userDAO, EntityFactory entityFactory) {
        return new FlowableUserRequestHandler(userDataBinder, securityProperties.getAdminUser(), engine, userDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public FlowableWorkflowUtils flowableUtils(DomainProcessEngine engine) {
        return new FlowableWorkflowUtils(engine);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeEntitiesVariableType syncopeEntitiesVariableType() {
        return new SyncopeEntitiesVariableType();
    }

    @ConditionalOnMissingBean
    @Bean
    public IdGenerator idGenerator() {
        return new StrongUuidGenerator();
    }

    @ConditionalOnMissingBean
    @Bean
    @Scope(value="prototype")
    public SpringProcessEngineConfiguration processEngineConfiguration(WorkflowFlowableProperties props, SpringIdmEngineConfigurator syncopeIdmEngineConfigurator, IdGenerator idGenerator, SyncopeEntitiesVariableType syncopeEntitiesVariableType, SyncopeFormHandlerHelper syncopeFormHandlerHelper) {
        SpringProcessEngineConfiguration conf = new SpringProcessEngineConfiguration();
        conf.setDatabaseSchemaUpdate("true");
        conf.setJpaHandleTransaction(true);
        conf.setJpaCloseEntityManager(false);
        conf.setHistoryLevel(props.getHistoryLevel());
        conf.setIdmEngineConfigurator((EngineConfigurator)syncopeIdmEngineConfigurator);
        conf.setCustomPreVariableTypes(List.of(syncopeEntitiesVariableType));
        conf.setFormHandlerHelper((FormHandlerHelper)syncopeFormHandlerHelper);
        conf.setIdGenerator(idGenerator);
        conf.setPreBpmnParseHandlers(List.of(new ShellServiceTaskDisablingBpmnParseHandler()));
        return conf;
    }

    @ConditionalOnMissingBean
    @Bean
    public DomainProcessEngineFactoryBean domainProcessEngineFactoryBean(ConfigurableApplicationContext ctx) {
        return new DomainProcessEngineFactoryBean((ApplicationContext)ctx);
    }

    @Bean
    public Resource userWorkflowDef(WorkflowFlowableProperties props, ResourceLoader resourceLoader) {
        return resourceLoader.getResource(props.getUserWorkflowDef());
    }

    @ConditionalOnMissingBean(name={"flowableUWFAdapter"})
    @Bean
    public UserWorkflowAdapter uwfAdapter(UserDataBinder userDataBinder, UserDAO userDAO, RealmDAO realmDAO, EntityFactory entityFactory, SecurityProperties securityProperties, DomainProcessEngine engine, UserRequestHandler userRequestHandler, ApplicationEventPublisher publisher) {
        return new FlowableUserWorkflowAdapter(userDataBinder, userDAO, realmDAO, entityFactory, securityProperties, engine, userRequestHandler, publisher);
    }

    @ConditionalOnMissingBean
    @Bean
    public AutoActivate autoActivate(UserDataBinder userDataBinder, UserDAO userDAO) {
        return new AutoActivate(userDataBinder, userDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public Create create(UserDataBinder userDataBinder, EntityFactory entityFactory) {
        return new Create(userDataBinder, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public Delete delete() {
        return new Delete();
    }

    @ConditionalOnMissingBean
    @Bean
    public GenerateToken generateToken(ConfParamOps confParamOps) {
        return new GenerateToken(confParamOps);
    }

    @ConditionalOnMissingBean
    @Bean
    public Notify notify(NotificationManager notificationManager) {
        return new Notify(notificationManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public PasswordReset passwordReset(UserDataBinder userDataBinder, UserDAO userDAO) {
        return new PasswordReset(userDataBinder, userDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public Reactivate reactivate() {
        return new Reactivate();
    }

    @ConditionalOnMissingBean
    @Bean
    public Suspend suspend() {
        return new Suspend();
    }

    @ConditionalOnMissingBean
    @Bean
    public Update update(UserDataBinder userDataBinder, UserDAO userDAO) {
        return new Update(userDataBinder, userDAO);
    }
}

