/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class DeleteProducer
extends AbstractProducer {
    private final UserDAO userDAO;
    private final GroupDataBinder groupDataBinder;

    public DeleteProducer(Endpoint endpoint, AnyTypeKind anyTypeKind, UserDAO userDao, GroupDataBinder groupDataBinder) {
        super(endpoint, anyTypeKind);
        this.userDAO = userDao;
        this.groupDataBinder = groupDataBinder;
    }

    public void process(Exchange exchange) throws Exception {
        String key = (String)exchange.getIn().getBody(String.class);
        Set excludedResources = (Set)exchange.getProperty("excludedResources", Set.class);
        Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
        if (null != this.getAnyTypeKind()) {
            switch (this.getAnyTypeKind()) {
                case USER: {
                    PropagationByResource propByRes = new PropagationByResource();
                    propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceKeys(key));
                    List taskInfos = this.getPropagationManager().getDeleteTasks(AnyTypeKind.USER, key, propByRes, (Collection)excludedResources);
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
                    exchange.setProperty("statuses", (Object)propagationReporter.getStatuses());
                    break;
                }
                case GROUP: {
                    ArrayList taskInfos = new ArrayList();
                    for (Map.Entry entry : this.groupDataBinder.findUsersWithTransitiveResources(key).entrySet()) {
                        taskInfos.addAll(this.getPropagationManager().getDeleteTasks(AnyTypeKind.USER, (String)entry.getKey(), (PropagationByResource)entry.getValue(), (Collection)excludedResources));
                    }
                    for (Map.Entry entry : this.groupDataBinder.findAnyObjectsWithTransitiveResources(key).entrySet()) {
                        taskInfos.addAll(this.getPropagationManager().getDeleteTasks(AnyTypeKind.ANY_OBJECT, (String)entry.getKey(), (PropagationByResource)entry.getValue(), (Collection)excludedResources));
                    }
                    taskInfos.addAll(this.getPropagationManager().getDeleteTasks(AnyTypeKind.GROUP, key, null, null));
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute(taskInfos, nullPriorityAsync.booleanValue());
                    exchange.setProperty("statuses", (Object)propagationReporter.getStatuses());
                    break;
                }
                case ANY_OBJECT: {
                    List taskInfos = this.getPropagationManager().getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, null, (Collection)excludedResources);
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
                    exchange.setProperty("statuses", (Object)propagationReporter.getStatuses());
                    break;
                }
            }
        }
    }
}

