/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.component;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.camel.component.PropagateType;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;
import org.apache.syncope.core.provisioning.camel.producer.ConfirmPasswordResetProducer;
import org.apache.syncope.core.provisioning.camel.producer.CreateProducer;
import org.apache.syncope.core.provisioning.camel.producer.DeleteProducer;
import org.apache.syncope.core.provisioning.camel.producer.DeprovisionProducer;
import org.apache.syncope.core.provisioning.camel.producer.ProvisionProducer;
import org.apache.syncope.core.provisioning.camel.producer.StatusProducer;
import org.apache.syncope.core.provisioning.camel.producer.SuspendProducer;
import org.apache.syncope.core.provisioning.camel.producer.UpdateProducer;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;

@UriEndpoint(scheme="propagate", title="propagate", syntax="propagate:propagateType", producerOnly=true)
public class PropagateEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private PropagateType propagateType;
    @UriParam
    private AnyTypeKind anyTypeKind;
    @UriParam
    private boolean pull;
    private PropagationManager propagationManager;
    private PropagationTaskExecutor taskExecutor;
    private UserDAO userDAO;
    private GroupDAO groupDAO;
    private AnyObjectDAO anyObjectDAO;
    private GroupDataBinder groupDataBinder;
    private UserWorkflowAdapter uwfAdapter;

    public PropagateEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        AbstractProducer producer = null;
        if (null != this.propagateType) {
            switch (this.propagateType) {
                case create: {
                    producer = new CreateProducer((Endpoint)this, this.anyTypeKind);
                    break;
                }
                case update: {
                    producer = new UpdateProducer((Endpoint)this, this.anyTypeKind);
                    break;
                }
                case delete: {
                    producer = new DeleteProducer((Endpoint)this, this.anyTypeKind, this.userDAO, this.groupDataBinder);
                    break;
                }
                case provision: {
                    producer = new ProvisionProducer((Endpoint)this, this.anyTypeKind);
                    break;
                }
                case deprovision: {
                    producer = new DeprovisionProducer((Endpoint)this, this.anyTypeKind, this.userDAO, this.groupDAO, this.anyObjectDAO);
                    break;
                }
                case status: {
                    producer = new StatusProducer((Endpoint)this, this.anyTypeKind, this.userDAO, this.uwfAdapter);
                    break;
                }
                case suspend: {
                    producer = new SuspendProducer((Endpoint)this, this.anyTypeKind);
                    break;
                }
                case confirmPasswordReset: {
                    producer = new ConfirmPasswordResetProducer((Endpoint)this, this.anyTypeKind);
                    break;
                }
            }
        }
        if (producer != null) {
            producer.setPropagationManager(this.propagationManager);
            producer.setPropagationTaskExecutor(this.taskExecutor);
            producer.setPull(this.pull);
        }
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public boolean isSingleton() {
        return false;
    }

    public PropagateType getPropagateType() {
        return this.propagateType;
    }

    public void setPropagateType(PropagateType propagateType) {
        this.propagateType = propagateType;
    }

    public void setPropagationManager(PropagationManager propagationManager) {
        this.propagationManager = propagationManager;
    }

    public void setPropagationTaskExecutor(PropagationTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public AnyTypeKind getAnyTypeKind() {
        return this.anyTypeKind;
    }

    public void setAnyTypeKind(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setAnyObjectDAO(AnyObjectDAO anyObjectDAO) {
        this.anyObjectDAO = anyObjectDAO;
    }

    public void setGroupDataBinder(GroupDataBinder groupDataBinder) {
        this.groupDataBinder = groupDataBinder;
    }

    public boolean isPull() {
        return this.pull;
    }

    public void setPull(boolean pull) {
        this.pull = pull;
    }

    public void setUwfAdapter(UserWorkflowAdapter uwfAdapter) {
        this.uwfAdapter = uwfAdapter;
    }
}

