/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.camel.AbstractCamelProvisioningManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CamelAnyObjectProvisioningManager
extends AbstractCamelProvisioningManager
implements AnyObjectProvisioningManager {
    public Pair<String, List<PropagationStatus>> create(AnyObjectTO any, boolean nullPriorityAsync) {
        return this.create(any, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(AnyObjectTO anyObjectTO, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:createAnyObjectPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:createAnyObject", anyObjectTO, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<AnyObjectPatch, List<PropagationStatus>> update(AnyObjectPatch anyPatch, boolean nullPriorityAsync) {
        return this.update(anyPatch, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<AnyObjectPatch, List<PropagationStatus>> update(AnyObjectPatch anyPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:updateAnyObjectPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:updateAnyObject", anyPatch, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public List<PropagationStatus> delete(String anyObjectObjectKey, boolean nullPriorityAsync) {
        return this.delete(anyObjectObjectKey, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deleteAnyObjectPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deleteAnyObject", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public String unlink(AnyObjectPatch anyObjectPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:unlinkAnyObjectPort");
        this.sendMessage("direct:unlinkAnyObject", anyObjectPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((AnyObjectPatch)exchange.getIn().getBody(AnyObjectPatch.class)).getKey();
    }

    public String link(AnyObjectPatch anyObjectPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:linkAnyObjectPort");
        this.sendMessage("direct:linkAnyObject", anyObjectPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((AnyObjectPatch)exchange.getIn().getBody(AnyObjectPatch.class)).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:provisionAnyObjectPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:provisionAnyObject", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deprovisionAnyObjectPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deprovisionAnyObject", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }
}

