/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateParamConverterProvider
implements ParamConverterProvider {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ");

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Date.class.equals(rawType)) {
            return new DateParamConverter();
        }
        return null;
    }

    private static class DateParamConverter
    implements ParamConverter<Date> {
        private DateParamConverter() {
        }

        public Date fromString(String value) {
            try {
                return DATE_FORMAT.parse(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Unparsable date: " + value, e);
            }
        }

        public String toString(Date value) {
            return DATE_FORMAT.format(value);
        }
    }
}

