/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.rest.api.beans.AbstractTimeframeQuery;

public class AuditQuery
extends AbstractTimeframeQuery {
    private static final long serialVersionUID = -2863334226169614417L;
    private String entityKey;
    private AuditElements.EventCategoryType type;
    private String category;
    private String subcategory;
    private final List<String> events = new ArrayList<String>();
    private AuditElements.Result result;

    @Parameter(name="entityKey", description="audit entity key to match", schema=@Schema(implementation=String.class, example="50592942-73ec-44c4-a377-e859524245e4"))
    public String getEntityKey() {
        return this.entityKey;
    }

    @NotNull
    @QueryParam(value="entityKey")
    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    @Parameter(name="type", description="audit type to match", schema=@Schema(implementation=AuditElements.EventCategoryType.class))
    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    @QueryParam(value="type")
    public void setType(AuditElements.EventCategoryType type) {
        this.type = type;
    }

    @Parameter(name="category", description="audit category to match", schema=@Schema(implementation=String.class))
    public String getCategory() {
        return this.category;
    }

    @QueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @Parameter(name="subcategory", description="audit subcategory to match", schema=@Schema(implementation=String.class))
    public String getSubcategory() {
        return this.subcategory;
    }

    @QueryParam(value="subcategory")
    public void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    @Parameter(name="result", description="audit result to match", schema=@Schema(implementation=AuditElements.Result.class))
    public AuditElements.Result getResult() {
        return this.result;
    }

    @QueryParam(value="result")
    public void setResult(AuditElements.Result result) {
        this.result = result;
    }

    @Parameter(name="events", description="audit events(s) to match", array=@ArraySchema(uniqueItems=true, schema=@Schema(implementation=String.class)))
    public List<String> getEvents() {
        return this.events;
    }

    @QueryParam(value="events")
    public void setEvents(List<String> events) {
        if (events != null) {
            this.events.addAll(events);
        }
    }

    public static class Builder
    extends AbstractTimeframeQuery.Builder<AuditQuery, Builder> {
        @Override
        protected AuditQuery newInstance() {
            return new AuditQuery();
        }

        public Builder entityKey(String entityKey) {
            ((AuditQuery)this.getInstance()).setEntityKey(entityKey);
            return this;
        }

        public Builder type(AuditElements.EventCategoryType type) {
            ((AuditQuery)this.getInstance()).setType(type);
            return this;
        }

        public Builder category(String category) {
            ((AuditQuery)this.getInstance()).setCategory(category);
            return this;
        }

        public Builder subcategory(String subcategory) {
            ((AuditQuery)this.getInstance()).setSubcategory(subcategory);
            return this;
        }

        public Builder event(String event) {
            ((AuditQuery)this.getInstance()).getEvents().add(event);
            return this;
        }

        public Builder events(List<String> events) {
            ((AuditQuery)this.getInstance()).setEvents(events);
            return this;
        }

        public Builder result(AuditElements.Result result) {
            ((AuditQuery)this.getInstance()).setResult(result);
            return this;
        }
    }
}

