/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.log.EventCategoryTO;
import org.apache.syncope.common.lib.log.LogAppender;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Loggers"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="loggers")
public interface LoggerService
extends JAXRSService {
    @GET
    @Path(value="memoryAppenders")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<LogAppender> memoryAppenders();

    @GET
    @Path(value="memoryAppenders/{memoryAppender}/lastLogStatements")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<LogStatementTO> getLastLogStatements(@NotNull @PathParam(value="memoryAppender") String var1);

    @GET
    @Path(value="events")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<EventCategoryTO> events();

    @GET
    @Path(value="{type}/{name}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public LoggerTO read(@NotNull @PathParam(value="type") LoggerType var1, @NotNull @PathParam(value="name") String var2);

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<LoggerTO> list(@NotNull @PathParam(value="type") LoggerType var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", paramType="path", dataType="string", value="Logger's key")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="type") LoggerType var1, @NotNull LoggerTO var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{type}/{name}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="type") LoggerType var1, @NotNull @PathParam(value="name") String var2);
}

