/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;

@XmlRootElement(name="connInstance")
@XmlType
public class ConnInstanceTO
implements EntityTO {
    private static final long serialVersionUID = 2707778645445168671L;
    private String key;
    private String adminRealm;
    private String location;
    private String connectorName;
    private String bundleName;
    private String version;
    private final List<ConnConfProperty> conf = new ArrayList<ConnConfProperty>();
    private final Set<ConnectorCapability> capabilities = EnumSet.noneOf(ConnectorCapability.class);
    private String displayName;
    private Integer connRequestTimeout;
    private ConnPoolConfTO poolConf;

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public String getAdminRealm() {
        return this.adminRealm;
    }

    public void setAdminRealm(String adminRealm) {
        this.adminRealm = adminRealm;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorname) {
        this.connectorName = connectorname;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundlename) {
        this.bundleName = bundlename;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElementWrapper(name="conf")
    @XmlElement(name="property")
    @JsonProperty(value="conf")
    public List<ConnConfProperty> getConf() {
        return this.conf;
    }

    @JsonIgnore
    public Optional<ConnConfProperty> getConf(String schemaName) {
        return this.conf.stream().filter(property -> property.getSchema().getName().equals(schemaName)).findFirst();
    }

    @XmlElementWrapper(name="capabilities")
    @XmlElement(name="capability")
    @JsonProperty(value="capabilities")
    public Set<ConnectorCapability> getCapabilities() {
        return this.capabilities;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getConnRequestTimeout() {
        return this.connRequestTimeout;
    }

    public void setConnRequestTimeout(Integer connRequestTimeout) {
        this.connRequestTimeout = connRequestTimeout;
    }

    public ConnPoolConfTO getPoolConf() {
        return this.poolConf;
    }

    public void setPoolConf(ConnPoolConfTO poolConf) {
        this.poolConf = poolConf;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnInstanceTO other = (ConnInstanceTO)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.adminRealm, (Object)other.adminRealm).append((Object)this.location, (Object)other.location).append((Object)this.connectorName, (Object)other.connectorName).append((Object)this.bundleName, (Object)other.bundleName).append((Object)this.version, (Object)other.version).append(this.conf, other.conf).append(this.capabilities, other.capabilities).append((Object)this.displayName, (Object)other.displayName).append((Object)this.connRequestTimeout, (Object)other.connRequestTimeout).append((Object)this.poolConf, (Object)other.poolConf).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.adminRealm).append((Object)this.location).append((Object)this.connectorName).append((Object)this.bundleName).append((Object)this.version).append(this.conf).append(this.capabilities).append((Object)this.displayName).append((Object)this.connRequestTimeout).append((Object)this.poolConf).build();
    }
}

