/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.HashSet;
import java.util.Set;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.types.ClientExceptionType;

public class SyncopeClientException
extends RuntimeException {
    private static final long serialVersionUID = 3380920886511913475L;
    private ClientExceptionType type;
    private final Set<String> elements = new HashSet<String>();

    public static SyncopeClientException build(ClientExceptionType type) {
        if (type == ClientExceptionType.Composite) {
            throw new IllegalArgumentException("Composite exceptions must be obtained via buildComposite()");
        }
        return new SyncopeClientException(type);
    }

    public static SyncopeClientCompositeException buildComposite() {
        return new SyncopeClientCompositeException();
    }

    protected SyncopeClientException(ClientExceptionType type) {
        this.setType(type);
    }

    public boolean isComposite() {
        return this.getType() == ClientExceptionType.Composite;
    }

    public SyncopeClientCompositeException asComposite() {
        if (!this.isComposite()) {
            throw new IllegalArgumentException("This is not a composite exception");
        }
        return (SyncopeClientCompositeException)this;
    }

    public ClientExceptionType getType() {
        return this.type;
    }

    public final void setType(ClientExceptionType type) {
        this.type = type;
    }

    public Set<String> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public String getMessage() {
        return "" + (Object)((Object)this.getType()) + ' ' + this.getElements();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

