/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;

@XmlRootElement(name="mapping")
@XmlType
public class MappingTO
implements ItemContainerTO,
Serializable {
    private static final long serialVersionUID = 8447688036282611118L;
    private String connObjectLink;
    private final List<ItemTO> items = new ArrayList<ItemTO>();
    private final List<ItemTO> linkingItems = new ArrayList<ItemTO>();

    public String getConnObjectLink() {
        return this.connObjectLink;
    }

    public void setConnObjectLink(String connObjectLink) {
        this.connObjectLink = connObjectLink;
    }

    @Override
    public ItemTO getConnObjectKeyItem() {
        return this.getItems().stream().filter(item -> item.isConnObjectKey()).findFirst().orElse(null);
    }

    protected boolean addConnObjectKeyItem(ItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    @Override
    public boolean setConnObjectKeyItem(ItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @Override
    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<ItemTO> getItems() {
        return this.items;
    }

    @Override
    public boolean add(ItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(ItemTO item) {
        return this.items.remove(item);
    }

    @XmlElementWrapper(name="linkingItems")
    @XmlElement(name="item")
    @JsonProperty(value="linkingItems")
    public List<ItemTO> getLinkingItems() {
        return this.linkingItems;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingTO other = (MappingTO)obj;
        return new EqualsBuilder().append((Object)this.connObjectLink, (Object)other.connObjectLink).append(this.items, other.items).append(this.linkingItems, other.linkingItems).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.connObjectLink).append(this.items).append(this.linkingItems).build();
    }
}

