/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;

@XmlType
@XmlSeeAlso(value={AnyTO.class})
public abstract class AbstractAnnotatedBean
extends BaseBean
implements EntityTO {
    private static final long serialVersionUID = -930797879027642457L;
    private String creator;
    private Date creationDate;
    private String lastModifier;
    private Date lastChangeDate;

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Date getLastChangeDate() {
        if (this.lastChangeDate != null) {
            return new Date(this.lastChangeDate.getTime());
        }
        return null;
    }

    public void setLastChangeDate(Date lastChangeDate) {
        this.lastChangeDate = lastChangeDate != null ? new Date(lastChangeDate.getTime()) : null;
    }

    @JsonIgnore
    public String getETagValue() {
        Date etagDate = this.getLastChangeDate() == null ? this.getCreationDate() : this.getLastChangeDate();
        return etagDate == null ? "" : String.valueOf(etagDate.getTime());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.creator).append((Object)this.creationDate).append((Object)this.lastModifier).append((Object)this.lastChangeDate).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAnnotatedBean other = (AbstractAnnotatedBean)obj;
        return new EqualsBuilder().append((Object)this.creator, (Object)other.creator).append((Object)this.creationDate, (Object)other.creationDate).append((Object)this.lastModifier, (Object)other.lastModifier).append((Object)this.lastChangeDate, (Object)other.lastChangeDate).build();
    }
}

