/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="user")
@XmlType
public class UserTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 7791304495192615740L;
    private String password;
    private final List<String> roles = new ArrayList<String>();
    private final List<String> dynRoles = new ArrayList<String>();
    private String token;
    private Date tokenExpireTime;
    private String username;
    private Date lastLoginDate;
    private Date changePwdDate;
    private Integer failedLogins;
    private String securityQuestion;
    private String securityAnswer;
    private boolean mustChangePassword;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<String> dynGroups = new ArrayList<String>();

    @Override
    public String getType() {
        return AnyTypeKind.USER.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    @XmlElementWrapper(name="dynRoles")
    @XmlElement(name="role")
    @JsonProperty(value="dynRoles")
    public List<String> getDynRoles() {
        return this.dynRoles;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Date getTokenExpireTime() {
        if (this.tokenExpireTime != null) {
            return new Date(this.tokenExpireTime.getTime());
        }
        return null;
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime != null ? new Date(tokenExpireTime.getTime()) : null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getChangePwdDate() {
        if (this.changePwdDate != null) {
            return new Date(this.changePwdDate.getTime());
        }
        return null;
    }

    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    public Date getLastLoginDate() {
        if (this.lastLoginDate != null) {
            return new Date(this.lastLoginDate.getTime());
        }
        return null;
    }

    public void setChangePwdDate(Date changePwdDate) {
        this.changePwdDate = changePwdDate != null ? new Date(changePwdDate.getTime()) : null;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate != null ? new Date(lastLoginDate.getTime()) : null;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @Override
    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public Map<Pair<String, String>, RelationshipTO> getRelationshipMap() {
        HashMap<Pair, RelationshipTO> result = new HashMap<Pair, RelationshipTO>(this.getRelationships().size());
        for (RelationshipTO relationship : this.getRelationships()) {
            result.put(Pair.of((Object)relationship.getType(), (Object)relationship.getRightKey()), relationship);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @JsonIgnore
    public Map<String, MembershipTO> getMembershipMap() {
        HashMap<String, MembershipTO> result = new HashMap(this.getMemberships().size());
        for (MembershipTO membership : this.getMemberships()) {
            result.put(membership.getRightKey(), membership);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    @Override
    @XmlElementWrapper(name="dynGroups")
    @XmlElement(name="role")
    @JsonProperty(value="dynGroups")
    public List<String> getDynGroups() {
        return this.dynGroups;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("password");
            }
        }.toString();
    }
}

