/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.text.ParseException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.log.EventCategoryTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.LoggerType;

@XmlRootElement(name="auditLoggerName")
@XmlType
public class AuditLoggerName
extends AbstractBaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    private AuditElements.EventCategoryType type = AuditElements.EventCategoryType.CUSTOM;
    private String category;
    private String subcategory;
    private String event;
    private AuditElements.Result result = AuditElements.Result.SUCCESS;

    public static String getAuditLoggerName(String domain) {
        return LoggerType.AUDIT.getPrefix() + "." + domain;
    }

    public static String getAuditEventLoggerName(String domain, String loggerName) {
        return domain + "." + loggerName;
    }

    public static AuditLoggerName fromLoggerName(String loggerName) throws ParseException {
        if (StringUtils.isBlank((CharSequence)loggerName)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!loggerName.startsWith(LoggerType.AUDIT.getPrefix())) {
            throw new ParseException("Audit logger name must start with " + LoggerType.AUDIT.getPrefix(), 0);
        }
        Pair<EventCategoryTO, AuditElements.Result> eventCategory = AuditLoggerName.parseEventCategory(loggerName.replaceAll(LoggerType.AUDIT.getPrefix() + ".", ""));
        return new Builder().type(((EventCategoryTO)eventCategory.getKey()).getType()).category(((EventCategoryTO)eventCategory.getKey()).getCategory()).subcategory(((EventCategoryTO)eventCategory.getKey()).getSubcategory()).event(((EventCategoryTO)eventCategory.getKey()).getEvents().isEmpty() ? "" : ((EventCategoryTO)eventCategory.getKey()).getEvents().iterator().next()).result((AuditElements.Result)((Object)eventCategory.getValue())).build();
    }

    public static Pair<EventCategoryTO, AuditElements.Result> parseEventCategory(String event) {
        EventCategoryTO eventCategoryTO = new EventCategoryTO();
        AuditElements.Result condition = null;
        if (StringUtils.isNotEmpty((CharSequence)event)) {
            String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
            if (elements.length == 1) {
                eventCategoryTO.setType(AuditElements.EventCategoryType.CUSTOM);
                condition = AuditElements.Result.SUCCESS;
                eventCategoryTO.getEvents().add(event);
            } else {
                AuditElements.EventCategoryType type;
                if (AuditElements.EventCategoryType.PROPAGATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PROPAGATION;
                } else if (AuditElements.EventCategoryType.PULL.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PULL;
                } else if (AuditElements.EventCategoryType.PUSH.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PUSH;
                } else {
                    try {
                        type = AuditElements.EventCategoryType.valueOf(elements[0]);
                    }
                    catch (Exception e) {
                        type = AuditElements.EventCategoryType.CUSTOM;
                    }
                }
                eventCategoryTO.setType(type);
                eventCategoryTO.setCategory(StringUtils.isNotEmpty((CharSequence)elements[1]) ? elements[1] : null);
                eventCategoryTO.setSubcategory(StringUtils.isNotEmpty((CharSequence)elements[2]) ? elements[2] : null);
                if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                    eventCategoryTO.getEvents().add(elements[3]);
                }
                if (elements.length > 4) {
                    condition = AuditElements.Result.valueOf(elements[4].toUpperCase());
                }
            }
        }
        return Pair.of((Object)eventCategoryTO, condition);
    }

    public static String buildEvent(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            eventBuilder.append(type.toString());
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)event)) {
            eventBuilder.append(event);
        }
        eventBuilder.append(']');
        if (condition != null) {
            eventBuilder.append(":[").append((Object)condition).append(']');
        }
        return eventBuilder.toString();
    }

    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    public void setType(AuditElements.EventCategoryType type) {
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public void setResult(AuditElements.Result result) {
        this.result = result;
    }

    public String toLoggerName() {
        return LoggerType.AUDIT.getPrefix() + '.' + AuditLoggerName.buildEvent(this.type, this.category, this.subcategory, this.event, this.result);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.category).append((Object)this.subcategory).append((Object)this.event).append((Object)this.result).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditLoggerName other = (AuditLoggerName)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.category, (Object)other.category).append((Object)this.subcategory, (Object)other.subcategory).append((Object)this.event, (Object)other.event).append((Object)this.result, (Object)other.result).build();
    }

    public static class Builder {
        private final AuditLoggerName instance = new AuditLoggerName();

        public Builder type(AuditElements.EventCategoryType type) {
            this.instance.type = type;
            return this;
        }

        public Builder category(String category) {
            this.instance.category = category;
            return this;
        }

        public Builder subcategory(String subcategory) {
            this.instance.subcategory = subcategory;
            return this;
        }

        public Builder event(String event) {
            this.instance.event = event;
            return this;
        }

        public Builder result(AuditElements.Result result) {
            this.instance.result = result;
            return this;
        }

        public AuditLoggerName build() {
            return this.instance;
        }
    }
}

