/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.builder.ToStringExclude;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="user")
@XmlType
@ApiModel(parent=AnyTO.class)
public class UserTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 7791304495192615740L;
    @ToStringExclude
    private String password;
    private final List<String> roles = new ArrayList<String>();
    private final List<String> dynRoles = new ArrayList<String>();
    private String token;
    private Date tokenExpireTime;
    private String username;
    private Date lastLoginDate;
    private Date changePwdDate;
    private Integer failedLogins;
    private String securityQuestion;
    private String securityAnswer;
    private boolean suspended;
    private boolean mustChangePassword;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<MembershipTO> dynMemberships = new ArrayList<MembershipTO>();

    @Override
    @JsonProperty(value="@class")
    @ApiModelProperty(name="@class", required=true, example="org.apache.syncope.common.lib.to.UserTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @Override
    public String getType() {
        return AnyTypeKind.USER.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    @ApiModelProperty(readOnly=true)
    @XmlElementWrapper(name="dynRoles")
    @XmlElement(name="role")
    @JsonProperty(value="dynRoles")
    public List<String> getDynRoles() {
        return this.dynRoles;
    }

    @ApiModelProperty(readOnly=true)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @ApiModelProperty(readOnly=true)
    public Date getTokenExpireTime() {
        if (this.tokenExpireTime != null) {
            return new Date(this.tokenExpireTime.getTime());
        }
        return null;
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime != null ? new Date(tokenExpireTime.getTime()) : null;
    }

    @JsonProperty(required=true)
    @XmlElement(required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ApiModelProperty(readOnly=true)
    public Date getChangePwdDate() {
        if (this.changePwdDate != null) {
            return new Date(this.changePwdDate.getTime());
        }
        return null;
    }

    @ApiModelProperty(readOnly=true)
    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    @ApiModelProperty(readOnly=true)
    public Date getLastLoginDate() {
        if (this.lastLoginDate != null) {
            return new Date(this.lastLoginDate.getTime());
        }
        return null;
    }

    public void setChangePwdDate(Date changePwdDate) {
        this.changePwdDate = changePwdDate != null ? new Date(changePwdDate.getTime()) : null;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate != null ? new Date(lastLoginDate.getTime()) : null;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    @ApiModelProperty(readOnly=true)
    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    @ApiModelProperty(readOnly=true)
    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @Override
    @JsonIgnore
    public RelationshipTO getRelationship(final String type, final String otherKey) {
        return (RelationshipTO)IterableUtils.find(this.relationships, (Predicate)new Predicate<RelationshipTO>(){

            public boolean evaluate(RelationshipTO relationship) {
                return type.equals(relationship.getType()) && otherKey.equals(relationship.getOtherEndKey());
            }
        });
    }

    @Override
    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public MembershipTO getMembership(final String groupKey) {
        return (MembershipTO)IterableUtils.find(this.memberships, (Predicate)new Predicate<MembershipTO>(){

            public boolean evaluate(MembershipTO object) {
                return groupKey.equals(object.getGroupKey());
            }
        });
    }

    @Override
    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @ApiModelProperty(readOnly=true)
    @XmlElementWrapper(name="dynMemberships")
    @XmlElement(name="dynMembership")
    @JsonProperty(value="dynMemberships")
    public List<MembershipTO> getDynMemberships() {
        return this.dynMemberships;
    }
}

