/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.common.lib.patch;

import java.util.Collection;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;

@XmlRootElement(name = "associationPatch")
@XmlType
public class AssociationPatch extends PasswordPatch {

    private static final long serialVersionUID = 6295778399633883767L;

    public static class Builder extends PasswordPatch.Builder {

        @Override
        protected AssociationPatch newInstance() {
            return new AssociationPatch();
        }

        @Override
        protected AssociationPatch getInstance() {
            return (AssociationPatch) super.getInstance();
        }

        @Override
        public AssociationPatch build() {
            return (AssociationPatch) super.build();
        }

        @Override
        public Builder onSyncope(final boolean onSyncope) {
            return (Builder) super.onSyncope(onSyncope);
        }

        @Override
        public Builder resource(final String resource) {
            return (Builder) super.resource(resource);
        }

        @Override
        public Builder resources(final Collection<String> resources) {
            return (Builder) super.resources(resources);
        }

        @Override
        public Builder resources(final String... resources) {
            return (Builder) super.resources(resources);
        }

        @Override
        public Builder value(final String value) {
            return (Builder) super.value(value);
        }

        public Builder key(final String key) {
            getInstance().setKey(key);
            return this;
        }

        public Builder action(final ResourceAssociationAction action) {
            getInstance().setAction(action);
            return this;
        }
    }

    private String key;

    private ResourceAssociationAction action;

    public String getKey() {
        return key;
    }

    @PathParam("key")
    public void setKey(final String key) {
        this.key = key;
    }

    public ResourceAssociationAction getAction() {
        return action;
    }

    @PathParam("action")
    public void setAction(final ResourceAssociationAction action) {
        this.action = action;
    }
}
