/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.BasicAuthenticationHandler;
import org.apache.syncope.client.lib.JWTAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.service.AccessTokenService;
import org.apache.syncope.common.rest.api.service.UserSelfService;

public class SyncopeClient {
    private static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    private final MediaType mediaType;
    private final JAXRSClientFactoryBean restClientFactory;
    private final RestClientExceptionMapper exceptionMapper;
    private final boolean useCompression;
    private final TLSClientParameters tlsClientParameters;

    public SyncopeClient(MediaType mediaType, JAXRSClientFactoryBean restClientFactory, RestClientExceptionMapper exceptionMapper, AuthenticationHandler handler, boolean useCompression, TLSClientParameters tlsClientParameters) {
        this.mediaType = mediaType;
        this.restClientFactory = restClientFactory;
        if (this.restClientFactory.getHeaders() == null) {
            this.restClientFactory.setHeaders(new HashMap());
        }
        this.exceptionMapper = exceptionMapper;
        this.tlsClientParameters = tlsClientParameters;
        this.init(handler);
        this.useCompression = useCompression;
    }

    protected void init(AuthenticationHandler handler) {
        this.cleanup();
        if (handler instanceof AnonymousAuthenticationHandler) {
            this.restClientFactory.setUsername(((AnonymousAuthenticationHandler)handler).getUsername());
            this.restClientFactory.setPassword(((AnonymousAuthenticationHandler)handler).getPassword());
        } else if (handler instanceof BasicAuthenticationHandler) {
            this.restClientFactory.setUsername(((BasicAuthenticationHandler)handler).getUsername());
            this.restClientFactory.setPassword(((BasicAuthenticationHandler)handler).getPassword());
            String jwt = this.getService(AccessTokenService.class).login().getHeaderString("X-Syncope-Token");
            this.restClientFactory.getHeaders().put("Authorization", Collections.singletonList("Bearer " + jwt));
            this.restClientFactory.setUsername(null);
            this.restClientFactory.setPassword(null);
        } else if (handler instanceof JWTAuthenticationHandler) {
            this.restClientFactory.getHeaders().put("Authorization", Collections.singletonList("Bearer " + ((JWTAuthenticationHandler)handler).getJwt()));
        }
    }

    protected void cleanup() {
        this.restClientFactory.getHeaders().remove("Authorization");
        this.restClientFactory.setUsername(null);
        this.restClientFactory.setPassword(null);
    }

    public void refresh() {
        String jwt = this.getService(AccessTokenService.class).refresh().getHeaderString("X-Syncope-Token");
        this.restClientFactory.getHeaders().put("Authorization", Collections.singletonList("Bearer " + jwt));
    }

    public void logout() {
        this.getService(AccessTokenService.class).logout();
        this.cleanup();
    }

    public void login(AuthenticationHandler handler) {
        this.init(handler);
    }

    public static UserFiqlSearchConditionBuilder getUserSearchConditionBuilder() {
        return new UserFiqlSearchConditionBuilder();
    }

    public static GroupFiqlSearchConditionBuilder getGroupSearchConditionBuilder() {
        return new GroupFiqlSearchConditionBuilder();
    }

    public static AnyObjectFiqlSearchConditionBuilder getAnyObjectSearchConditionBuilder(String type) {
        return new AnyObjectFiqlSearchConditionBuilder(type);
    }

    public static OrderByClauseBuilder getOrderByClauseBuilder() {
        return new OrderByClauseBuilder();
    }

    public String getJWT() {
        String header;
        List headerValues = (List)this.restClientFactory.getHeaders().get("Authorization");
        String string = header = headerValues == null || headerValues.isEmpty() ? null : (String)headerValues.get(0);
        if (header != null && header.startsWith("Bearer ")) {
            return header.substring("Bearer ".length());
        }
        return null;
    }

    public String getDomain() {
        List headerValues = (List)this.restClientFactory.getHeaders().get("X-Syncope-Domain");
        return headerValues == null || headerValues.isEmpty() ? "Master" : (String)headerValues.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        JAXRSClientFactoryBean jAXRSClientFactoryBean = this.restClientFactory;
        synchronized (jAXRSClientFactoryBean) {
            this.restClientFactory.setServiceClass(serviceClass);
            Object serviceInstance = this.restClientFactory.create(serviceClass, new Object[0]);
            Client client = WebClient.client((Object)serviceInstance);
            client.type(this.mediaType).accept(new MediaType[]{this.mediaType});
            ClientConfiguration config = WebClient.getConfig((Object)client);
            config.getRequestContext().put(HEADER_SPLIT_PROPERTY, true);
            config.getRequestContext().put("use.httpurlconnection.method.reflection", true);
            if (this.useCompression) {
                config.getInInterceptors().add(new GZIPInInterceptor());
                config.getOutInterceptors().add(new GZIPOutInterceptor());
            }
            if (this.tlsClientParameters != null) {
                HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
                httpConduit.setTlsClientParameters(this.tlsClientParameters);
            }
            return (T)serviceInstance;
        }
    }

    public Pair<Map<String, Set<String>>, UserTO> self() {
        Exception ex;
        UserSelfService service = this.getService(UserSelfService.class);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put(HEADER_SPLIT_PROPERTY, false);
        Response response = service.read();
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode() && (ex = this.exceptionMapper.fromResponse(response)) != null) {
            throw (RuntimeException)ex;
        }
        try {
            return Pair.of((Object)((Map)new ObjectMapper().readValue(response.getHeaderString("X-Syncope-Entitlements"), (TypeReference)new TypeReference<HashMap<String, Set<String>>>(){})), (Object)response.readEntity(UserTO.class));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T header(T service, String key, Object ... values) {
        WebClient.client(service).header(key, values);
        return service;
    }

    public <T> T prefer(T service, Preference preference) {
        return this.header(service, "Prefer", preference.toString());
    }

    public <T> T nullPriorityAsync(T service, boolean nullPriorityAsync) {
        return this.header(service, "X-Syncope-Null-Priority-Async", nullPriorityAsync);
    }

    private <T> T match(T service, EntityTag etag, boolean ifNot) {
        WebClient.client(service).match(etag, ifNot);
        return service;
    }

    public <T> T ifMatch(T service, EntityTag etag) {
        return this.match(service, etag, false);
    }

    public <T> T ifNoneMatch(T service, EntityTag etag) {
        return this.match(service, etag, true);
    }

    public <T> EntityTag getLatestEntityTag(T service) {
        return WebClient.client(service).getResponse().getEntityTag();
    }
}

