/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.RestClientFactoryBean;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.service.UserSelfService;

public class SyncopeClient {
    private final MediaType mediaType;
    private final RestClientFactoryBean restClientFactory;
    private final RestClientExceptionMapper exceptionMapper;
    private final String username;
    private final String password;
    private final boolean useCompression;

    public SyncopeClient(MediaType mediaType, RestClientFactoryBean restClientFactory, RestClientExceptionMapper exceptionMapper, String username, String password, boolean useCompression) {
        this.mediaType = mediaType;
        this.restClientFactory = restClientFactory;
        this.exceptionMapper = exceptionMapper;
        this.username = username;
        this.password = password;
        this.useCompression = useCompression;
    }

    public static UserFiqlSearchConditionBuilder getUserSearchConditionBuilder() {
        return new UserFiqlSearchConditionBuilder();
    }

    public static GroupFiqlSearchConditionBuilder getGroupSearchConditionBuilder() {
        return new GroupFiqlSearchConditionBuilder();
    }

    public static AnyObjectFiqlSearchConditionBuilder getAnyObjectSearchConditionBuilder(String type) {
        return new AnyObjectFiqlSearchConditionBuilder(type);
    }

    public static OrderByClauseBuilder getOrderByClauseBuilder() {
        return new OrderByClauseBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        RestClientFactoryBean restClientFactoryBean = this.restClientFactory;
        synchronized (restClientFactoryBean) {
            return this.restClientFactory.createServiceInstance(serviceClass, this.mediaType, this.username, this.password, this.useCompression);
        }
    }

    public Pair<Map<String, Set<String>>, UserTO> self() {
        Exception ex;
        UserSelfService service = this.getService(UserSelfService.class);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put("org.apache.cxf.http.header.split", false);
        Response response = service.read();
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode() && (ex = this.exceptionMapper.fromResponse(response)) != null) {
            throw (RuntimeException)ex;
        }
        try {
            return new ImmutablePair((Object)((Map)new ObjectMapper().readValue(response.getHeaderString("X-Syncope-Entitlements"), (TypeReference)new TypeReference<HashMap<String, Set<String>>>(){})), response.readEntity(UserTO.class));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T header(T service, String key, Object ... values) {
        WebClient.client(service).header(key, values);
        return service;
    }

    public <T> T header(Class<T> serviceClass, String key, Object ... values) {
        return this.header(this.getService(serviceClass), key, values);
    }

    public <T> T prefer(T service, Preference preference) {
        return this.header(service, "Prefer", preference.toString());
    }

    public <T> T prefer(Class<T> serviceClass, Preference preference) {
        return this.header(serviceClass, "Prefer", new Object[]{preference.toString()});
    }

    public <T> T nullPriorityAsync(Class<T> serviceClass, boolean nullPriorityAsync) {
        return this.header(serviceClass, "X-Syncope-Null-Priority-Async", new Object[]{nullPriorityAsync});
    }

    private <T> T match(T service, EntityTag etag, boolean ifNot) {
        WebClient.client(service).match(etag, ifNot);
        return service;
    }

    public <T> T ifMatch(T service, EntityTag etag) {
        return this.match(service, etag, false);
    }

    public <T> T ifMatch(Class<T> serviceClass, EntityTag etag) {
        return this.match(this.getService(serviceClass), etag, false);
    }

    public <T> T ifNoneMatch(T service, EntityTag etag) {
        return this.match(service, etag, true);
    }

    public <T> T ifNoneMatch(Class<T> serviceClass, EntityTag etag) {
        return this.match(this.getService(serviceClass), etag, true);
    }

    public <T> EntityTag getLatestEntityTag(T service) {
        return WebClient.client(service).getResponse().getEntityTag();
    }
}

