/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.init;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.wicket.request.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope.client.enduser";
    private List<Class<? extends AbstractResource>> resources;

    protected String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.resources = new ArrayList<Class<? extends AbstractResource>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractResource.class));
        for (BeanDefinition bd : scanner.findCandidateComponents(this.getBasePackage())) {
            try {
                Class clazz = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbsractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (isAbsractClazz || !AbstractResource.class.isAssignableFrom(clazz)) continue;
                if (clazz.isAnnotationPresent(Resource.class)) {
                    this.resources.add(clazz);
                    continue;
                }
                LOG.error("Could not find annotation {} in {}, ignoring", (Object)Resource.class.getName(), (Object)clazz.getName());
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.resources = Collections.unmodifiableList(this.resources);
    }

    public List<Class<? extends AbstractResource>> getResources() {
        return this.resources;
    }
}

