/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyObjectWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.TemplateWizardBuilder;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.wicket.PageReference;

public class AnyObjectTemplateWizardBuilder
extends AnyObjectWizardBuilder
implements TemplateWizardBuilder<AnyObjectTO> {
    private static final long serialVersionUID = 6716803168859873877L;
    private final TemplatableTO templatable;

    public AnyObjectTemplateWizardBuilder(TemplatableTO templatable, String anyType, List<String> anyTypeClasses, AnyObjectFormLayoutInfo formLayoutInfo, PageReference pageRef) {
        super((AnyObjectTO)null, anyTypeClasses, formLayoutInfo, pageRef);
        this.templatable = templatable;
        if (templatable.getTemplates().containsKey(anyType)) {
            this.setItem(new AnyWrapper<AnyTO>((AnyTO)AnyObjectTO.class.cast(templatable.getTemplates().get(anyType))));
        } else {
            AnyObjectTO anyObjectTO = new AnyObjectTO();
            anyObjectTO.setType(anyType);
            if (templatable instanceof RealmTO) {
                anyObjectTO.setRealm(String.format("'%s'", RealmsUtils.getFullPath(((RealmTO)RealmTO.class.cast(templatable)).getFullPath())));
            }
            this.setItem(new AnyWrapper<AnyObjectTO>(anyObjectTO));
        }
    }

    @Override
    protected Optional<Details<AnyObjectTO>> addOptionalDetailsPanel(AnyWrapper<AnyObjectTO> modelObject) {
        Optional<Details<AnyObjectTO>> details = super.addOptionalDetailsPanel(modelObject);
        if (this.templatable instanceof RealmTO && details.isPresent()) {
            details.get().disableRealmSpecification();
        }
        return details;
    }

    @Override
    public AjaxWizard<AnyWrapper<AnyObjectTO>> build(String id) {
        return super.build(id, AjaxWizard.Mode.TEMPLATE);
    }
}

